/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.api.plant.PlantAPI;

public class PlantFunctions {
    private static Table<PlantAPI.PlantType, PlantAPI.PlantEvent, byte[]> plantChanceTable = PlantFunctions.buildPlantChanceTable();
    private static byte[] saplingGrow = new byte[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private static byte[] fruitFlower = new byte[]{25, 25, 25, 25, 25, 25, 15, 25, 15, 15};
    private static byte[] fruitGrow = new byte[]{40, 40, 40, 50, 40, 50, 30, 40, 20, 20};
    private static byte[] fruitFall = new byte[]{50, 50, 50, 60, 50, 60, 40, 50, 50, 50};
    private static byte[] saplingDrop = new byte[]{15, 20, 15, 20, 15, 20, 12, 15, 8, 8};

    private static Table<PlantAPI.PlantType, PlantAPI.PlantEvent, byte[]> buildPlantChanceTable() {
        HashBasedTable table = HashBasedTable.create();
        table.put((Object)PlantAPI.PlantType.FLOWER, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new byte[]{10, 9});
        table.put((Object)PlantAPI.PlantType.FLOWER, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new byte[]{20, 18});
        table.put((Object)PlantAPI.PlantType.GRASS, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new byte[]{95, 75});
        table.put((Object)PlantAPI.PlantType.GRASS, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new byte[]{20, 18});
        table.put((Object)PlantAPI.PlantType.PINEAPPLE, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new byte[]{8, 5});
        table.put((Object)PlantAPI.PlantType.PINEAPPLE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new byte[]{40, 40});
        table.put((Object)PlantAPI.PlantType.CACTUS, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new byte[]{0, 8});
        table.put((Object)PlantAPI.PlantType.CACTUS, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new byte[]{0, 40});
        table.put((Object)PlantAPI.PlantType.GRAPEVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new byte[]{15, 13});
        table.put((Object)PlantAPI.PlantType.GRAPEVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new byte[]{40, 40});
        table.put((Object)PlantAPI.PlantType.LIFEVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new byte[]{15, 13});
        table.put((Object)PlantAPI.PlantType.LIFEVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new byte[]{40, 40});
        table.put((Object)PlantAPI.PlantType.DEATHVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new byte[]{15, 13});
        table.put((Object)PlantAPI.PlantType.DEATHVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new byte[]{40, 40});
        return table;
    }

    public static boolean canGrow(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.PlantGrow)) {
            return false;
        }
        byte[] chances = (byte[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.PlantGrow);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.PlantGrow, plant, (IBlockAccess)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean canSpread(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.PlantSpread)) {
            return false;
        }
        byte[] chances = (byte[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.PlantSpread);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.PlantSpread, plant, (IBlockAccess)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean canGrowFruit(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.FruitGrow)) {
            return false;
        }
        byte[] chances = (byte[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.FruitGrow);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.FruitGrow, plant, (IBlockAccess)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static byte getMaxPlacementAttempts(IBlockAccess world, BlockPos pos, PlantAPI.PlantType plant) {
        switch (plant) {
            case FLOWER: {
                return PlantAPI.getPlacementValue(PlantAPI.PlacementValue.FlowerMaxAttempts, world, pos, 5);
            }
            case GRASS: {
                return PlantAPI.getPlacementValue(PlantAPI.PlacementValue.GrassMaxAttempts, world, pos, 5);
            }
        }
        return 0;
    }

    public static byte[] getSpreadRadius(IBlockAccess world, BlockPos pos, PlantAPI.PlantType plant) {
        byte radius;
        switch (plant) {
            case FLOWER: {
                radius = PlantAPI.getPlacementValue(PlantAPI.PlacementValue.FlowerSpreadRadius, world, pos, 3);
                break;
            }
            case GRASS: {
                radius = PlantAPI.getPlacementValue(PlantAPI.PlacementValue.GrassSpreadRadius, world, pos, 3);
                break;
            }
            default: {
                radius = 0;
            }
        }
        byte[] spreadRadius = new byte[]{radius > 0 ? radius : (byte)1, (byte)(radius / 3 * 2) > 0 ? (byte)(radius / 3 * 2) : (byte)1};
        return spreadRadius;
    }

    public static boolean canSaplingGrow(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.SaplingGrow, tree, world, pos, saplingGrow[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean growFruitFlower(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitFlower, tree, world, pos, fruitFlower[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean growFruit(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitGrow, tree, world, pos, fruitGrow[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean dropFruit(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = Settings.INSTANCE.fruitStaysOnTrees ? 0 : PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitFall, tree, world, pos, fruitFall[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean dropSapling(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.SaplingDrop, tree, world, pos, saplingDrop[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }
}

