/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaBase;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaWall;

public class TileEntityPergolaFrame
extends TileEntityPergolaBase {
    private static final AxisAlignedBB AABB_BLOCK = new AxisAlignedBB(0.0, 0.0625, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_UPPER = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_POST = new AxisAlignedBB(0.375, 0.0, 0.375, 0.75, 0.5, 0.75);

    private BlockPergola.EnumStyle isPergolaBlock(EnumFacing facing) {
        TileEntity tile;
        BlockPos pos = this.func_174877_v().func_177972_a(facing);
        if (!this.func_145831_w().func_175623_d(pos) && (tile = this.func_145831_w().func_175625_s(pos)) instanceof TileEntityPergolaFrame) {
            return BlockPergola.EnumStyle.NORMAL;
        }
        return BlockPergola.EnumStyle.NONE;
    }

    @Override
    protected String getType() {
        BlockPergola.EnumStyle north = this.isPergolaBlock(EnumFacing.NORTH);
        BlockPergola.EnumStyle east = this.isPergolaBlock(EnumFacing.EAST);
        BlockPergola.EnumStyle south = this.isPergolaBlock(EnumFacing.SOUTH);
        BlockPergola.EnumStyle west = this.isPergolaBlock(EnumFacing.WEST);
        BlockPergola.EnumStyle down = BlockPergola.EnumStyle.NONE;
        if (!this.func_145831_w().func_175623_d(this.func_174877_v().func_177977_b())) {
            boolean post = true;
            TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
            if (tile instanceof TileEntityPergolaWall) {
                String type = ((TileEntityPergolaWall)tile).getSavedType(false);
                boolean bl = post = !Strings.isNullOrEmpty((String)type) && !type.contains("xd=none");
            }
            if (post) {
                down = BlockPergola.EnumStyle.NORMAL;
            }
        }
        if (north == east && east == south && south == west && west == BlockPergola.EnumStyle.NORMAL) {
            EnumFacing[] check;
            for (EnumFacing facing : check = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST}) {
                String type;
                TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
                if (!(tile instanceof TileEntityPergolaFrame) || Strings.isNullOrEmpty((String)(type = ((TileEntityPergolaFrame)tile).getSavedType(false))) || !type.startsWith("ed=normal,nd=none,sd=normal,wd=normal") && !type.startsWith("ed=normal,nd=normal,sd=none,wd=normal")) continue;
                south = west = BlockPergola.EnumStyle.MIDDLE;
                east = west;
                north = west;
            }
        }
        return "ed=" + east.func_176610_l() + ",nd=" + north.func_176610_l() + ",sd=" + south.func_176610_l() + ",wd=" + west.func_176610_l() + ",xd=" + down.func_176610_l();
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        String type = this.getSavedType(true);
        if (!Strings.isNullOrEmpty((String)type) && !type.endsWith("xd=normal")) {
            if (type.startsWith("ed=normal,nd=normal,sd=normal,wd=normal") || type.startsWith("ed=normal,nd=none,sd=normal,wd=normal") || type.startsWith("ed=normal,nd=normal,sd=none,wd=normal") || type.startsWith("ed=normal,nd=none,sd=none,wd=normal")) {
                return AABB_UPPER;
            }
            return AABB_BLOCK;
        }
        return Block.field_185505_j;
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        String type = this.getSavedType(true);
        if (!Strings.isNullOrEmpty((String)type)) {
            if (type.startsWith("ed=normal,nd=normal,sd=normal,wd=normal") || type.startsWith("ed=normal,nd=none,sd=normal,wd=normal") || type.startsWith("ed=normal,nd=normal,sd=none,wd=normal") || type.startsWith("ed=normal,nd=none,sd=none,wd=normal")) {
                boxes.add(AABB_UPPER);
            } else {
                boxes.add(Block.field_185505_j);
            }
            if (type.endsWith("xd=normal")) {
                boxes.add(AABB_POST);
            }
        } else {
            boxes.add(this.getBoxBounds());
        }
        return boxes;
    }
}

