/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.tileentity.EnumPassageStatus;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaBase;

public class TileEntityPergolaGate
extends TileEntityPergolaBase
implements ITickable {
    private static final AxisAlignedBB AABB_NS = new AxisAlignedBB(0.0, 0.125, 0.4375, 1.0, 0.875, 0.5625);
    private static final AxisAlignedBB AABB_NST = new AxisAlignedBB(0.0, 0.75, 0.4375, 1.0, 1.0, 0.5625);
    private static final AxisAlignedBB AABB_EW = new AxisAlignedBB(0.4375, 0.125, 0.0, 0.5625, 0.875, 1.0);
    private static final AxisAlignedBB AABB_EWT = new AxisAlignedBB(0.4375, 0.75, 0.0, 0.5625, 1.0, 1.0);
    private EnumPassageStatus gateStatus = EnumPassageStatus.CLOSED;
    private BlockPergola.EnumCover gateCover = BlockPergola.EnumCover.NONE;
    public EnumFacing gateFacing = EnumFacing.NORTH;
    private long lastUsed;

    public void func_73660_a() {
        if (!this.isOvergrown()) {
            ++this.lastUsed;
        }
    }

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74778_a("facing", this.gateFacing.func_176610_l());
        nbtTag.func_74774_a("status", this.getStatus().getValue());
        nbtTag.func_74778_a("cover", this.gateCover.getName());
        nbtTag.func_74772_a("lastUsed", this.lastUsed);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        this.gateFacing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
        this.setStatus(EnumPassageStatus.byValue(nbtTag.func_74771_c("status")));
        this.gateCover = BlockPergola.EnumCover.byName(nbtTag.func_74779_i("cover"));
        this.lastUsed = nbtTag.func_74763_f("lastUsed");
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a(BlockPergola.VARIANT, (Comparable)((Object)BlockPergola.EnumType.withTypes(BlockPergola.EnumBase.GATE, this.gateCover)));
    }

    @Override
    protected String getType() {
        boolean northsouth = this.isNorthOrSouth(this.gateFacing);
        boolean northwest = this.isNorthOrWest(this.gateFacing);
        boolean down = this.isGate(EnumFacing.DOWN);
        boolean up = this.isGate(EnumFacing.UP);
        boolean isOpen = !down && this.getStatus().isOpen();
        String name = northsouth ? "ed=none,nd=" : "ed=";
        name = name + (isOpen ? (northwest ? "bottom" : "top") : "normal");
        name = name + (northsouth ? "" : ",nd=none");
        name = name + ",sd=none,wd=none,";
        name = name + (up && down ? "xd=middle" : (down ? "xd=top" : "xd=bottom"));
        return name;
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        if (this.isNorthOrSouth(this.gateFacing)) {
            return this.isGate(EnumFacing.DOWN) ? AABB_NST : AABB_NS;
        }
        return this.isGate(EnumFacing.DOWN) ? AABB_EWT : AABB_EW;
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        if (!this.getStatus().isOpen() && !this.isGate(EnumFacing.DOWN)) {
            boxes.add(this.getBoxBounds().func_186666_e(1.5));
            return boxes;
        }
        boxes.add(Block.field_185506_k);
        return boxes;
    }

    public boolean blockActivated(EntityPlayer player) {
        if (this.isOvergrown()) {
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187575_bT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        this.lastUsed = 0L;
        if (!this.func_145831_w().field_72995_K) {
            EnumPassageStatus newStatus = this.getStatus();
            boolean isOpen = this.getStatus().isOpen();
            boolean isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
            switch (this.getStatus()) {
                case CLOSED: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.OPEN;
                    break;
                }
                case OPEN: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.CLOSED;
                    break;
                }
                case CLOSED_POWERED: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.CLOSED;
                    break;
                }
                case OPEN_POWERED: {
                    newStatus = isPowered ? EnumPassageStatus.CLOSED_POWERED : EnumPassageStatus.CLOSED;
                }
            }
            this.setStatus(newStatus);
            if (player != null && newStatus.isOpen()) {
                EnumFacing facing = player.func_174811_aO();
                if (this.isNorthOrSouth(this.gateFacing) == this.isNorthOrSouth(facing)) {
                    this.gateFacing = facing;
                }
            }
            Function.syncTile((TileEntity)this);
            if (isOpen != this.getStatus().isOpen()) {
                this.func_145831_w().func_180498_a(null, isOpen ? 1014 : 1008, this.func_174877_v(), 0);
            }
        }
        this.setSavedType(this.getType());
        return true;
    }

    private boolean isNorthOrWest(EnumFacing facing) {
        return facing == EnumFacing.NORTH || facing == EnumFacing.WEST;
    }

    protected EnumFacing getFacing() {
        return this.gateFacing;
    }

    private boolean isGate(EnumFacing facing) {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
        if (tile instanceof TileEntityPergolaGate) {
            TileEntityPergolaGate gate = (TileEntityPergolaGate)tile;
            return this.isNorthOrSouth(gate.getFacing()) == this.isNorthOrSouth(this.getFacing());
        }
        return false;
    }

    @Override
    public void neighborChanged(Block neighbor) {
        super.neighborChanged(neighbor);
        boolean isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
        if (isPowered && !this.getStatus().isPowered() || !isPowered && this.getStatus().isPowered()) {
            this.blockActivated(null);
        }
    }

    public boolean blockMovementAI() {
        return !this.getStatus().isOpen();
    }

    public void setDefaultStatus() {
        this.gateStatus = EnumPassageStatus.CLOSED;
    }

    public void setCover(BlockPergola.EnumCover cover) {
        if (cover == null) {
            cover = BlockPergola.EnumCover.NONE;
        }
        this.gateCover = cover;
        Function.syncTile((TileEntity)this);
    }

    public boolean isOvergrown() {
        return this.gateCover != BlockPergola.EnumCover.NONE;
    }

    public boolean shouldOvergrow() {
        int[] delay = new int[]{36000, 12000};
        if (this.lastUsed > (long)delay[0]) {
            int chances = (int)((this.lastUsed - (long)delay[0]) / (long)delay[1]);
            for (int chance = 0; chance < chances; ++chance) {
                if (!this.func_145831_w().field_73012_v.nextBoolean()) continue;
                return true;
            }
        }
        return false;
    }

    private EnumPassageStatus getStatus() {
        if (this.gateStatus == null) {
            this.setDefaultStatus();
        }
        return this.gateStatus;
    }

    private void setStatus(EnumPassageStatus status) {
        this.gateStatus = status;
    }
}

