/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockTypeBase;
import shetiphian.terraqueous.common.tileentity.EnumPassageStatus;
import shetiphian.terraqueous.common.tileentity.TileEntityTypePassageBase;

public class TileEntityTypeTrapdoor
extends TileEntityTypePassageBase {
    private static final AxisAlignedBB AABB_UPPER = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_LOWER = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    public byte style = 0;
    public EnumFacing facing = EnumFacing.NORTH;
    public boolean inverted = false;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("style", this.style);
        nbtTag.func_74778_a("facing", this.facing.func_176610_l());
        nbtTag.func_74757_a("inverted", this.inverted);
        nbtTag.func_74774_a("status", this.getStatus().getValue());
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.style = nbtTag.func_74771_c("style");
        this.facing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
        this.inverted = nbtTag.func_74767_n("inverted");
        this.setStatus(EnumPassageStatus.byValue(nbtTag.func_74771_c("status")));
        this.setSavedType(null);
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        state = ((BlockTypeBase)this.func_145838_q()).getBlockType(state, this.style);
        if (this.getSavedType() == null) {
            String name = "trapdoor_" + (this.getStatus().isOpen() ? "open_" : (this.inverted ? "invert_" : "")) + this.facing.func_176610_l();
            this.setSavedType(BlockTypeBase.EnumType.byName(name));
        }
        return state.func_177226_a(BlockTypeBase.VARIANT, (Comparable)((Object)this.getSavedType()));
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        if (!this.getStatus().isOpen()) {
            return this.inverted ? AABB_UPPER : AABB_LOWER;
        }
        switch (this.facing) {
            case SOUTH: {
                return AABB_SOUTH;
            }
            case WEST: {
                return AABB_WEST;
            }
            case NORTH: {
                return AABB_NORTH;
            }
            case EAST: {
                return AABB_EAST;
            }
        }
        return Block.field_185505_j;
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.add(this.getBoxBounds());
        return boxes;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, ItemStack heldItem) {
        if (!this.func_145831_w().field_72995_K) {
            EnumPassageStatus newStatus = this.getStatus();
            boolean isOpen = this.getStatus().isOpen();
            boolean isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
            switch (this.getStatus()) {
                case CLOSED: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.OPEN;
                    break;
                }
                case OPEN: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.CLOSED;
                    break;
                }
                case CLOSED_POWERED: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.CLOSED;
                    break;
                }
                case OPEN_POWERED: {
                    newStatus = isPowered ? EnumPassageStatus.CLOSED_POWERED : EnumPassageStatus.CLOSED;
                }
            }
            this.setStatus(newStatus);
            Function.syncTile((TileEntity)this);
            if (isOpen != this.getStatus().isOpen()) {
                this.func_145831_w().func_180498_a(null, isOpen ? 1013 : 1007, this.func_174877_v(), 0);
            }
        }
        return true;
    }

    @Override
    public void neighborChanged(Block neighbor) {
        boolean isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
        if (isPowered && !this.getStatus().isPowered() || !isPowered && this.getStatus().isPowered()) {
            this.blockActivated(null, null);
        }
    }

    @Override
    public boolean blockMovementAI() {
        return !this.getStatus().isOpen();
    }

    @Override
    public int getDamageValue() {
        return super.getDamageValue() + this.style;
    }

    @Override
    public boolean rotateBlock(EnumFacing axis) {
        this.inverted = !this.inverted;
        Function.syncTile((TileEntity)this);
        return true;
    }

    @Override
    public boolean isLadder(EntityLivingBase entity) {
        return this.getStatus().isOpen();
    }
}

