/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockDoodad;
import shetiphian.terraqueous.common.block.BlockEarthOre;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class GenDoodads
extends GenBase {
    public static boolean generateDoodad_Stick;
    public static boolean generateDoodad_Stone;
    public static boolean generateDoodad_Bone;
    public static boolean generateDoodad_Sandstone;
    public static boolean generateDoodad_Endimium;
    public static boolean generateDoodad_Burnium;

    public GenDoodads() {
        this.mustHaveSky = false;
    }

    @Override
    public void generate(Random random, World world, BlockPos pos) {
        if (Values.blockDoodad == null) {
            return;
        }
        if (random.nextInt(3) != 0) {
            this.generateBurniumCrystals(random, world, pos);
        }
        if (random.nextInt(3) != 0) {
            this.generateEndimiumCrystals(random, world, pos);
        }
        if (random.nextInt(3) != 0) {
            this.generateSticksStonesAndBones(random, world, pos);
        }
    }

    private void generateBurniumCrystals(Random random, World world, BlockPos pos) {
        if (!generateDoodad_Burnium) {
            return;
        }
        if (!BiomeDictionary.isBiomeOfType((Biome)world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return;
        }
        BlockPos sPos = new BlockPos(pos.func_177958_n(), 1, pos.func_177952_p());
        while (sPos.func_177956_o() < world.func_72940_L()) {
            if (random.nextBoolean() && random.nextBoolean() && world.func_175623_d(sPos) && world.isSideSolid(sPos.func_177977_b(), EnumFacing.UP, false)) {
                IBlockState crystalBurnium = BlockDoodad.EnumType.BURNIUM.state();
                IBlockState oreBurnium = BlockEarthOre.EnumType.BURNIUM_ORE.state();
                if (world.func_180495_p(sPos.func_177977_b()).func_177230_c() == Blocks.field_150424_aL) {
                    this.placeCrystal(world, sPos, crystalBurnium, oreBurnium, false, random, Blocks.field_150424_aL);
                    this.placeCrystal(world, sPos.func_177976_e(), crystalBurnium, oreBurnium, true, random, Blocks.field_150424_aL);
                    this.placeCrystal(world, sPos.func_177974_f(), crystalBurnium, oreBurnium, true, random, Blocks.field_150424_aL);
                    this.placeCrystal(world, sPos.func_177978_c(), crystalBurnium, oreBurnium, true, random, Blocks.field_150424_aL);
                    this.placeCrystal(world, sPos.func_177968_d(), crystalBurnium, oreBurnium, true, random, Blocks.field_150424_aL);
                    if (Values.blockEarthOre != null) {
                        this.generateOre(world, sPos, oreBurnium, random, Blocks.field_150424_aL);
                    }
                }
            }
            sPos = sPos.func_177984_a();
        }
    }

    private void generateEndimiumCrystals(Random random, World world, BlockPos pos) {
        if (!generateDoodad_Endimium) {
            return;
        }
        if (!BiomeDictionary.isBiomeOfType((Biome)world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()), (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            return;
        }
        if (!world.isSideSolid((pos = this.getTopBlock(world, pos)).func_177977_b(), EnumFacing.UP, false)) {
            return;
        }
        if (random.nextBoolean()) {
            return;
        }
        IBlockState crystalEndimium = BlockDoodad.EnumType.ENDIMIUM.state();
        IBlockState oreEndimium = BlockEarthOre.EnumType.ENDIMIUM_ORE.state();
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150377_bs) {
            this.placeCrystal(world, pos, crystalEndimium, oreEndimium, false, random, Blocks.field_150377_bs);
            if (Values.blockEarthOre != null) {
                this.generateOre(world, pos, oreEndimium, random, Blocks.field_150377_bs);
            }
        }
    }

    private void placeCrystal(World world, BlockPos pos, IBlockState crystal, IBlockState ore, boolean isExtra, Random random, Block replace) {
        if (isExtra) {
            if (!world.func_175623_d(pos) || !world.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false)) {
                return;
            }
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != replace || !random.nextBoolean()) {
                return;
            }
        }
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)crystal, (boolean)false);
        if (ore != null) {
            Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)ore, (boolean)false);
        }
    }

    private void generateOre(World world, BlockPos pos, IBlockState ore, Random random, Block replaceBlock) {
        pos = pos.func_177977_b();
        int yMin = pos.func_177956_o() - (random.nextInt(4) + 1);
        int yMax = pos.func_177956_o() + (random.nextInt(4) + 1);
        for (int yCurrent = yMin; yCurrent <= yMax; ++yCurrent) {
            int parts = random.nextInt(6) + 1;
            for (int part = 0; part < parts; ++part) {
                int xOffset = random.nextInt(5) - 3;
                int zOffset = random.nextInt(5) - 3;
                int xMin = pos.func_177958_n() - (random.nextInt(1) + 1) + xOffset;
                int xMax = pos.func_177958_n() + (random.nextInt(1) + 1) + xOffset;
                int zMin = pos.func_177952_p() - (random.nextInt(1) + 1) + zOffset;
                int zMax = pos.func_177952_p() + (random.nextInt(1) + 1) + zOffset;
                for (int xCurrent = xMin; xCurrent <= xMax; ++xCurrent) {
                    for (int zCurrent = zMin; zCurrent <= zMax; ++zCurrent) {
                        BlockPos place = new BlockPos(xCurrent, yCurrent, zCurrent);
                        if (world.func_180495_p(place).func_177230_c() != replaceBlock) continue;
                        Function.setBlock((World)world, (BlockPos)place, (IBlockState)ore, (boolean)false);
                    }
                }
            }
        }
    }

    private void generateSticksStonesAndBones(Random random, World world, BlockPos pos) {
        BlockPos basePos = pos;
        for (int pass = 0; pass < 4; pass = (int)((byte)(pass + 1))) {
            Biome biome;
            DecorateBiomeEvent.Decorate.EventType eventType = pass == 0 || pass == 3 ? DecorateBiomeEvent.Decorate.EventType.TREE : DecorateBiomeEvent.Decorate.EventType.CUSTOM;
            if (!TerrainGen.decorate((World)world, (Random)random, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)eventType) || (pass == 0 || pass == 3) && !generateDoodad_Stick || pass == 1 && !generateDoodad_Stone || pass == 2 && !generateDoodad_Bone || BiomeDictionary.isBiomeOfType((Biome)(biome = world.func_175726_f(pos = this.getRandomXZ(random, basePos)).func_177411_a(pos, world.func_72959_q())), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || !world.isSideSolid((pos = this.getTopBlock(world, pos)).func_177977_b(), EnumFacing.UP, false)) continue;
            IBlockState state = null;
            if (pass == 0 || pass == 2 || pass == 3) {
                if (BiomeDictionary.isBiomeRegistered((Biome)biome)) {
                    BiomeDictionary.Type[] types;
                    for (BiomeDictionary.Type type : types = BiomeDictionary.getTypesForBiome((Biome)biome)) {
                        if (!(pass != 0 && pass != 3 || type != BiomeDictionary.Type.JUNGLE && type != BiomeDictionary.Type.FOREST)) {
                            state = BlockDoodad.EnumType.BRANCH.state();
                        } else {
                            if (pass != 2 || type != BiomeDictionary.Type.SANDY) continue;
                            state = BlockDoodad.EnumType.BONE.state();
                        }
                        break;
                    }
                }
            } else {
                BlockSand.EnumType type;
                IBlockState sState = world.func_180495_p(pos.func_177977_b());
                Block block = sState.func_177230_c();
                state = block == Blocks.field_150322_A || block == Blocks.field_180395_cM ? (block == Blocks.field_180395_cM ? BlockDoodad.EnumType.REDSANDSTONE.state() : BlockDoodad.EnumType.SANDSTONE.state()) : (block instanceof BlockSand ? ((type = (BlockSand.EnumType)sState.func_177229_b((IProperty)BlockSand.field_176504_a)) == BlockSand.EnumType.RED_SAND ? BlockDoodad.EnumType.REDSANDSTONE.state() : BlockDoodad.EnumType.SANDSTONE.state()) : BlockDoodad.EnumType.STONE.state());
            }
            if (state == null) continue;
            Function.setBlock((World)world, (BlockPos)pos, state, (boolean)false);
        }
    }
}

