/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class GenPlants
extends GenBase {
    public static boolean generatePlant_Pineapple;
    public static boolean generatePlant_CactusPear;

    @Override
    public void generate(Random random, World world, BlockPos pos) {
        if (Values.blockPlants == null || !generatePlant_CactusPear && !generatePlant_Pineapple) {
            return;
        }
        List<Integer> plants = this.getPlantsForBiome(world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()));
        if (!plants.isEmpty()) {
            pos = this.getTopBlock(world, pos);
            int plantMeta = plants.get(random.nextInt(plants.size()));
            IBlockState state = Values.blockPlants.func_176203_a(plantMeta);
            Block soil = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (plantMeta >= 0 && plantMeta <= 2 && soil.canSustainPlant(Blocks.field_150345_g.func_176223_P(), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150345_g)) {
                if (!TerrainGen.decorate((World)world, (Random)random, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN)) {
                    return;
                }
                if (plantMeta == 2) {
                    Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockPlants.func_176203_a(plantMeta - 1), (boolean)false);
                    Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)state, (boolean)false);
                } else {
                    Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false);
                }
            }
            if (plantMeta >= 3 && plantMeta <= 6 && soil.canSustainPlant(Blocks.field_150434_aF.func_176223_P(), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150434_aF)) {
                if (!TerrainGen.decorate((World)world, (Random)random, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
                    return;
                }
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false);
            }
        }
    }

    private List<Integer> getPlantsForBiome(Biome biome) {
        ArrayList<Integer> plantList = new ArrayList<Integer>();
        if (BiomeDictionary.isBiomeRegistered((Biome)biome)) {
            if (generatePlant_Pineapple && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                plantList.add(0);
                plantList.add(1);
                plantList.add(2);
            }
            if (generatePlant_CactusPear && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                plantList.add(3);
                plantList.add(4);
                plantList.add(5);
            }
        }
        return plantList;
    }
}

