/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration;

import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import shetiphian.terraqueous.Recipes;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.modintegration.bc.BC_Comms;
import shetiphian.terraqueous.modintegration.forestry.Forestry_Comms;
import shetiphian.terraqueous.modintegration.multipart.Multipart_Comms;
import shetiphian.terraqueous.modintegration.pixelpowers.PixPow_Comms;
import shetiphian.terraqueous.modintegration.tropicraft.Tropicraft_Extras;

public class ModIntegration {
    private static String base = "shetiphian.terraqueous.modintegration.";

    public void load() {
        Settings.Setup setup = Settings.INSTANCE.setup();
        this.loadAPIs(setup);
        this.sendComms(setup);
        this.addExtras(setup);
    }

    private void loadAPIs(Settings.Setup setup) {
        ClassLoader classLoader = Terraqueous.class.getClassLoader();
        if (setup.enableComputerCraft) {
            this.loadAPI(classLoader, "computercraft.ComputerCraft_Active");
        }
        if (setup.enableForestry) {
            this.loadAPI(classLoader, "forestry.Forestry_Active");
        }
        if (setup.enableOpenComputers) {
            this.loadAPI(classLoader, "opencomputers.OpenComputer_Active");
        }
        this.loadAPI(classLoader, "power.EnergyUnits");
        this.loadAPI(classLoader, "power.ForgeUnits");
        this.loadAPI(classLoader, "power.ImmersiveFlux");
        this.loadAPI(classLoader, "power.Joules");
        this.loadAPI(classLoader, "power.RedstoneFlux");
        this.loadAPI(classLoader, "power.Tesla");
        this.loadAPI(classLoader, "repair.Basic");
        this.loadAPI(classLoader, "repair.TiC");
    }

    private void loadAPI(ClassLoader classLoader, String name) {
        try {
            classLoader.loadClass(base + name).getMethod("init", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendComms(Settings.Setup setup) {
        FMLInterModComms.sendMessage((String)"shetiphiancore", (String)"loadGuideFile", (String)"Terraqueous:terraqueous.json");
        if (Loader.isModLoaded((String)"pixelpowers")) {
            PixPow_Comms.sendComms();
        }
        if (setup.enableBuildCraft && Loader.isModLoaded((String)"BuildCraft|Transport")) {
            BC_Comms.sendComms();
        }
        if (setup.enableForestry && Loader.isModLoaded((String)"Forestry")) {
            Forestry_Comms.sendComms();
        }
        if (setup.enableForgeMultiPart && Loader.isModLoaded((String)"ForgeMicroblock")) {
            Multipart_Comms.sendComms();
        }
        if (setup.enableWAILA && Loader.isModLoaded((String)"Waila")) {
            FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)(base + "waila.WailaDataProvider.callbackRegister"));
        }
    }

    private void addExtras(Settings.Setup setup) {
        if (Values.blockTypeCloud != null) {
            Item item = null;
            if (Loader.isModLoaded((String)"harvestcraft")) {
                item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("harvestcraft", "freshwaterItem"));
            }
            if (item != null) {
                Recipes.getHelper().addShapelessRecipe(Terraqueous.getCustomItemStack("water_vapor", 4), new Object[]{item, item});
            } else {
                Recipes.getHelper().addShapelessRecipe(Terraqueous.getCustomItemStack("water_vapor", 4), new Object[]{Items.field_151131_as});
            }
        }
        if (setup.enableTropicraft && Loader.isModLoaded((String)"tropicraft")) {
            Tropicraft_Extras.addRecipes();
        }
    }
}

