/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.power;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;

public class Tesla {
    public static void init() {
        if (Settings.INSTANCE.sfPowerMultiplierTesla > 0.0f) {
            try {
                TeslaCapabilities.class.getName();
                StormForgeRegistry.register(new RechargeHandler());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class RechargeHandler
    implements IStormForgeRechargeHandler {
        @Override
        public boolean handleStack(ItemStack stack) {
            return stack != null && stack.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null) && stack.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
        }

        @Override
        public boolean charge(ItemStack stack, double amount, boolean outright) {
            ITeslaConsumer consumer;
            if (stack != null && (consumer = (ITeslaConsumer)stack.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null)) != null) {
                return consumer.givePower(outright ? Long.MAX_VALUE : (long)amount, false) > 0L;
            }
            return false;
        }

        @Override
        public boolean isFull(ItemStack stack) {
            ITeslaHolder holder;
            if (stack != null && (holder = (ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null)) != null) {
                return holder.getStoredPower() >= holder.getCapacity();
            }
            return true;
        }

        @Override
        public float multiplier() {
            return Settings.INSTANCE.sfPowerMultiplierTesla;
        }
    }
}

