/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;
import shetiphian.multibeds.modintegration.terraqueous.Terraqueous_Base;

public class ItemMultiBed
extends Item
implements IColored {
    public ItemMultiBed() {
        this.func_77655_b("multibeds.beds");
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a((CreativeTabs)Values.tabMultiBeds);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        if (Values.blockCloudBed != null) {
            list.add(new ItemStack(item, 1, 2));
        }
        for (int x = 3; x < 275; ++x) {
            list.add(new ItemStack(item, 1, x));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        String name = this.func_77658_a();
        int damage = itemStack.func_77952_i();
        if (damage == 0) {
            return name + ".baffle";
        }
        if (damage == 1) {
            return name + ".earth";
        }
        if (damage == 2) {
            return name + ".cloud";
        }
        if (damage < 19) {
            return name + ".spread";
        }
        if (damage < 275) {
            return name + ".decorative";
        }
        return "info.shetiphian.unused.name";
    }

    public String func_77653_i(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        if (damage < 19 || damage > 274) {
            return Localization.get((String)(this.func_77667_c(itemStack) + ".name"));
        }
        return Localization.get((String)(this.func_77667_c(itemStack) + ".name")) + " #" + (damage - 18);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean used = false;
        int damage = stack.func_77952_i();
        if (damage == 1 && Values.blockEarthBed != null) {
            used = this.placeBed(stack, player, world, pos, facing, false);
        } else if (damage == 2 && Values.blockCloudBed != null) {
            used = this.placeBed(stack, player, world, pos, facing, true);
        } else if (damage > 2 && damage < 275) {
            used = this.placeBedSpread(stack, player, world, pos, facing);
        }
        if (used && !player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        return used ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    private boolean placeBed(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face, boolean isCloud) {
        if (face != EnumFacing.UP) {
            return false;
        }
        pos = pos.func_177984_a();
        int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)direction);
        BlockPos oPos = pos.func_177972_a(enumfacing);
        if (player.func_175151_a(pos, face, stack) && player.func_175151_a(oPos, face, stack) && this.spotGood(world, pos, isCloud) && this.spotGood(world, oPos, isCloud)) {
            if (!world.field_72995_K) {
                SoundEvent sound = isCloud ? SoundEvents.field_187813_fI : SoundEvents.field_187891_gV;
                Block block = isCloud ? Values.blockCloudBed : Values.blockEarthBed;
                IBlockState state = block.func_176223_P().func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT);
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true);
                state = block.func_176223_P().func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
                Function.setBlock((World)world, (BlockPos)oPos, (IBlockState)state, (boolean)true);
                world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            return true;
        }
        return false;
    }

    private boolean spotGood(World world, BlockPos pos, boolean isCloud) {
        if (isCloud != Terraqueous_Base.INSTANCE.isBlockCloud(world.func_180495_p(pos.func_177977_b()), world, pos.func_177977_b())) {
            return false;
        }
        return world.func_175623_d(pos) && !world.func_175623_d(pos.func_177977_b());
    }

    private boolean placeBedSpread(ItemStack itemStack, EntityPlayer entityPlayer, World world, BlockPos pos, EnumFacing face) {
        if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockMultiBedBase)) {
            return false;
        }
        BlockPos[] bedBlocks = BlockMultiBedBase.getBlocks((IBlockAccess)world, pos);
        if (!entityPlayer.func_175151_a(bedBlocks[0], face, itemStack) || !entityPlayer.func_175151_a(bedBlocks[1], face, itemStack)) {
            return false;
        }
        TileEntityMultiBed[] bedTiles = BlockMultiBedBase.getTiles((IBlockAccess)world, pos);
        if (bedTiles == null) {
            return false;
        }
        if (!world.field_72995_K) {
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                if (bedTiles[0].hasSpread()) {
                    Function.dropItem((World)world, (BlockPos)bedBlocks[0], (ItemStack)new ItemStack((Item)this, 1, bedTiles[0].getSpread() + 2));
                } else if (bedTiles[1].hasSpread()) {
                    Function.dropItem((World)world, (BlockPos)bedBlocks[1], (ItemStack)new ItemStack((Item)this, 1, bedTiles[1].getSpread() + 2));
                }
            }
            bedTiles[0].setSpread(itemStack.func_77952_i() - 2);
            bedTiles[1].setSpread(itemStack.func_77952_i() - 2);
            Function.syncTile((TileEntity)bedTiles[0]);
            Function.syncTile((TileEntity)bedTiles[1]);
        }
        return true;
    }

    public int getColorFor(IColored.Data data, int index) {
        int dmg;
        int n = dmg = data.stack != null ? data.stack.func_77952_i() : 0;
        if (dmg < 3) {
            return 0xFFFFFF;
        }
        if (dmg < 19) {
            return ItemDye.field_150922_c[dmg - 3];
        }
        dmg -= 19;
        if (index == 0) {
            return ItemDye.field_150922_c[dmg / 16];
        }
        int color = ItemDye.field_150922_c[dmg % 16];
        if (dmg / 16 == dmg % 16) {
            return new Color(color).brighter().getRGB();
        }
        return color;
    }
}

