/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds;

import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import shetiphian.core.common.RegistryHelper;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.common.block.BlockEarthBed;
import shetiphian.multibeds.common.item.ItemMultiBed;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class Registry {
    void doRegistration() {
        this.registerBlocks();
        this.registerItems();
        this.setTabIcon();
        this.registerCustomItemStacks();
    }

    private void registerBlocks() {
        Values.blockEarthBed = RegistryHelper.registerBlock((Block)new BlockEarthBed(), null, (String)"earth_bed", (String)"multibeds.earthbed", (Object[])new Object[0]);
        RegistryHelper.registerTileEntity(TileEntityMultiBed.class, (String)"multibeds:beds.bed");
    }

    private void registerItems() {
        Values.itemBeds = RegistryHelper.registerItem((Item)new ItemMultiBed(), (String)"beds", (String)"multibeds.beds");
    }

    private void setTabIcon() {
        if (Values.itemBeds != null) {
            Values.tabMultiBeds.setIcon(this.iStack(Values.itemBeds, 1));
        }
    }

    private void registerCustomItemStacks() {
        int meta;
        if (Values.itemBeds == null) {
            return;
        }
        Values.stacks.put("baffle", this.iStack(Values.itemBeds, 0));
        Values.stacks.put("earthbed", this.iStack(Values.itemBeds, 1));
        Values.stacks.put("cloudbed", this.iStack(Values.itemBeds, 2));
        for (meta = 3; meta < 19; meta = (int)((short)(meta + 1))) {
            String color = EnumDyeColor.func_176766_a((int)(meta - 3)).func_176610_l();
            Values.stacks.put("spread_" + color, this.iStack(Values.itemBeds, meta));
        }
        for (meta = 19; meta < 275; meta = (int)((short)(meta + 1))) {
            Values.stacks.put("spread_" + (meta - 19), this.iStack(Values.itemBeds, meta));
        }
    }

    private ItemStack iStack(Item item, int metadata) {
        return new ItemStack(item, 1, metadata);
    }
}

