/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.common.item.ItemMultiBed;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public abstract class BlockMultiBedBase
extends BlockBed {
    public static final PropertyInteger SPREAD = PropertyInteger.func_177719_a((String)"spread", (int)0, (int)272);

    public BlockMultiBedBase() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SPREAD, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT).func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SPREAD, BlockBed.field_185512_D, BlockBed.field_176472_a, BlockBed.field_176471_b});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMultiBed();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        if (world.func_175625_s(pos) instanceof TileEntityMultiBed) {
            TileEntityMultiBed bedTile = (TileEntityMultiBed)world.func_175625_s(pos);
            state = state.func_177226_a((IProperty)SPREAD, (Comparable)Integer.valueOf(bedTile.getSpread()));
        }
        return state;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && heldItem != null && heldItem.func_77973_b() instanceof ItemMultiBed && heldItem.func_77952_i() > 2) {
            return false;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public boolean removeSpread(World world, BlockPos pos, EntityPlayer player) {
        TileEntityMultiBed[] bedTiles = BlockMultiBedBase.getTiles((IBlockAccess)world, pos);
        if (bedTiles != null && (bedTiles[0].hasSpread() || bedTiles[1].hasSpread())) {
            BlockPos[] bedBlocks = BlockMultiBedBase.getBlocks((IBlockAccess)world, pos);
            if (!player.field_71075_bZ.field_75098_d) {
                if (bedTiles[0].hasSpread()) {
                    Function.dropItem((World)world, (BlockPos)bedBlocks[0], (ItemStack)new ItemStack(Values.itemBeds, 1, bedTiles[0].getSpread() + 2));
                } else if (bedTiles[1].hasSpread()) {
                    Function.dropItem((World)world, (BlockPos)bedBlocks[1], (ItemStack)new ItemStack(Values.itemBeds, 1, bedTiles[1].getSpread() + 2));
                }
            }
            bedTiles[0].removeSpread();
            bedTiles[1].removeSpread();
            Function.syncTile((TileEntity)bedTiles[0]);
            Function.syncTile((TileEntity)bedTiles[1]);
            return true;
        }
        return false;
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        return true;
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return !BlockMultiBedBase.isBlockHeadOfBed(world.func_180495_p(pos));
    }

    private static boolean isBlockHeadOfBed(IBlockState state) {
        return ((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.HEAD);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        state = state.func_177226_a((IProperty)SPREAD, (Comparable)Integer.valueOf(tile instanceof TileEntityMultiBed ? (int)((TileEntityMultiBed)tile).getSpread() : 0));
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.func_180660_a(state, Function.random, fortune) != null) {
            int spread = (Integer)state.func_177229_b((IProperty)SPREAD);
            if (spread > 0) {
                ret.add(new ItemStack(Values.itemBeds, 1, spread + 2));
            }
            ret.add(new ItemStack(Values.itemBeds, 1, this.func_180651_a(state)));
        }
        return ret;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (BlockMultiBedBase.isBlockHeadOfBed(state)) {
            if (world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() != this) {
                world.func_175698_g(pos);
            }
        } else if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this) {
            state = this.func_176221_a(state, (IBlockAccess)world, pos);
            world.func_175698_g(pos);
            if (!world.field_72995_K) {
                this.func_176226_b(world, pos, state, 0);
            }
        }
    }

    public static BlockPos[] getBlocks(IBlockAccess world, BlockPos pos) {
        BlockPos[] bedPos = new BlockPos[]{pos, pos};
        IBlockState state = world.func_180495_p(pos);
        if (BlockMultiBedBase.isBlockHeadOfBed(state)) {
            bedPos[1] = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176734_d());
        } else {
            bedPos[0] = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D));
        }
        return bedPos;
    }

    public static TileEntityMultiBed[] getTiles(IBlockAccess world, BlockPos pos) {
        BlockPos[] bedBlocks = BlockMultiBedBase.getBlocks(world, pos);
        TileEntity[] tiles = new TileEntity[]{world.func_175625_s(bedBlocks[0]), world.func_175625_s(bedBlocks[1])};
        if (tiles[0] instanceof TileEntityMultiBed && tiles[1] instanceof TileEntityMultiBed) {
            return new TileEntityMultiBed[]{(TileEntityMultiBed)tiles[0], (TileEntityMultiBed)tiles[1]};
        }
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return BlockMultiBedBase.isBlockHeadOfBed(state) ? null : Values.itemBeds;
    }

    public abstract int func_180651_a(IBlockState var1);

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return BlockMultiBedBase.isBlockHeadOfBed(state) ? null : new ItemStack(Values.itemBeds, 1, this.func_180651_a(state));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        int metadata = this.func_180651_a(state);
        if (player != null && player.func_70093_af() && (tile = world.func_175625_s(pos)) instanceof TileEntityMultiBed && ((TileEntityMultiBed)tile).hasSpread()) {
            metadata = ((TileEntityMultiBed)tile).getSpread() + 2;
        }
        return new ItemStack(Values.itemBeds, 1, metadata);
    }
}

