/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.network;

import coloredlightscore.server.ChunkStorageRGB;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.client.Minecraft;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;

public class ChunkColorDataPacket
implements IMessage,
IMessageHandler<ChunkColorDataPacket, IMessage> {
    public int chunkXPosition;
    public int chunkZPosition;
    public int arraySize;
    public NibbleArray[] RedColorArray;
    public NibbleArray[] GreenColorArray;
    public NibbleArray[] BlueColorArray;
    public int[] yLocation;
    private final boolean USE_COMPRESSION = true;
    private static Method methodGetValueArray = null;

    public ChunkColorDataPacket() {
    }

    public ChunkColorDataPacket(Method methodGetValueArray) {
        ChunkColorDataPacket.methodGetValueArray = methodGetValueArray;
    }

    public IMessage onMessage(ChunkColorDataPacket packet, MessageContext context) {
        if (context.side == Side.CLIENT) {
            this.processColorDataPacket(packet);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void processColorDataPacket(ChunkColorDataPacket packet) {
        ChunkColorDataPacket ccdPacket = packet;
        Chunk targetChunk = null;
        targetChunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(ccdPacket.chunkXPosition, ccdPacket.chunkZPosition);
        if (targetChunk != null) {
            ChunkStorageRGB.loadColorData(targetChunk, ccdPacket.arraySize, ccdPacket.yLocation, ccdPacket.RedColorArray, ccdPacket.GreenColorArray, ccdPacket.BlueColorArray);
        } else {
            FMLLog.warning((String)"ProcessColorDataPacket()  Chunk located at (%s, %s) could not be found in the local world!", (Object[])new Object[]{ccdPacket.chunkXPosition, ccdPacket.chunkZPosition});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromBytes(ByteBuf bytes) {
        try {
            byte[] rawColorData = new byte[98304];
            byte[] compressedColorData = new byte[32000];
            byte[] nibbleData = new byte[2048];
            int p = 0;
            this.chunkXPosition = bytes.readInt();
            this.chunkZPosition = bytes.readInt();
            this.arraySize = bytes.readInt();
            this.yLocation = new int[this.arraySize];
            for (int i = 0; i < this.arraySize; ++i) {
                this.yLocation[i] = bytes.readInt();
            }
            int arraysPresent = bytes.readInt();
            this.RedColorArray = new NibbleArray[this.arraySize];
            this.GreenColorArray = new NibbleArray[this.arraySize];
            this.BlueColorArray = new NibbleArray[this.arraySize];
            int compressedSize = bytes.readInt();
            bytes.readBytes(compressedColorData, 0, compressedSize);
            Inflater inflater = new Inflater();
            inflater.setInput(compressedColorData);
            try {
                inflater.inflate(rawColorData);
            }
            catch (DataFormatException e) {
                FMLLog.warning((String)"ChunkColorDataPacket()  ", (Object[])new Object[]{e});
            }
            finally {
                inflater.end();
            }
            for (int i = 0; i < this.arraySize; ++i) {
                if ((arraysPresent & 1 << i) != 0) {
                    nibbleData = new byte[2048];
                    System.arraycopy(rawColorData, p, nibbleData, 0, 2048);
                    this.RedColorArray[i] = new NibbleArray(nibbleData, 4);
                    nibbleData = new byte[2048];
                    System.arraycopy(rawColorData, p += 2048, nibbleData, 0, 2048);
                    this.GreenColorArray[i] = new NibbleArray(nibbleData, 4);
                    nibbleData = new byte[2048];
                    System.arraycopy(rawColorData, p += 2048, nibbleData, 0, 2048);
                    this.BlueColorArray[i] = new NibbleArray(nibbleData, 4);
                    p += 2048;
                    continue;
                }
                this.RedColorArray[i] = new NibbleArray(4096, 4);
                this.GreenColorArray[i] = new NibbleArray(4096, 4);
                this.BlueColorArray[i] = new NibbleArray(4096, 4);
            }
        }
        catch (Exception e) {
            FMLLog.getLogger().error("fromBytes ", (Throwable)e);
        }
    }

    public void toBytes(ByteBuf bytes) {
        try {
            byte[] rawColorData = new byte[98304];
            byte[] compressedColorData = new byte[32000];
            int arraysPresent = 0;
            int p = 0;
            bytes.writeInt(this.chunkXPosition);
            bytes.writeInt(this.chunkZPosition);
            bytes.writeInt(this.arraySize);
            for (int i = 0; i < this.arraySize; ++i) {
                if (this.RedColorArray[i] != null || this.GreenColorArray[i] != null || this.BlueColorArray[i] != null) {
                    arraysPresent |= 1 << i;
                    if (FMLCommonHandler.instance().getModName().contains("cauldron")) {
                        byte[] localRed = (byte[])methodGetValueArray.invoke((Object)this.RedColorArray[i], new Object[0]);
                        byte[] localGreen = (byte[])methodGetValueArray.invoke((Object)this.GreenColorArray[i], new Object[0]);
                        byte[] localBlue = (byte[])methodGetValueArray.invoke((Object)this.BlueColorArray[i], new Object[0]);
                        System.arraycopy(localRed, 0, rawColorData, p, localRed.length);
                        System.arraycopy(localGreen, 0, rawColorData, p += localRed.length, localGreen.length);
                        System.arraycopy(localBlue, 0, rawColorData, p += localGreen.length, localBlue.length);
                        p += localBlue.length;
                    } else {
                        System.arraycopy(this.RedColorArray[i].field_76585_a, 0, rawColorData, p, this.RedColorArray[i].field_76585_a.length);
                        System.arraycopy(this.GreenColorArray[i].field_76585_a, 0, rawColorData, p += this.RedColorArray[i].field_76585_a.length, this.GreenColorArray[i].field_76585_a.length);
                        System.arraycopy(this.BlueColorArray[i].field_76585_a, 0, rawColorData, p += this.GreenColorArray[i].field_76585_a.length, this.BlueColorArray[i].field_76585_a.length);
                        p += this.BlueColorArray[i].field_76585_a.length;
                    }
                }
                bytes.writeInt(this.yLocation[i]);
            }
            bytes.writeInt(arraysPresent);
            Deflater deflate = new Deflater(-1);
            deflate.setInput(rawColorData);
            deflate.finish();
            int compressedSize = deflate.deflate(compressedColorData);
            if (compressedSize == 0) {
                FMLLog.warning((String)"writePacket compression failed", (Object[])new Object[0]);
            }
            bytes.writeInt(compressedSize);
            bytes.writeBytes(compressedColorData, 0, compressedSize);
        }
        catch (Exception e) {
            FMLLog.getLogger().error("toBytes  ", (Throwable)e);
        }
    }
}

