/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.network;

import coloredlightscore.network.ChunkColorDataPacket;
import coloredlightscore.server.ChunkStorageRGB;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;

public class PacketHandler {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("ColoredLightsCore");
    private static Method methodGetValueArray = null;

    public static void init() {
        INSTANCE.registerMessage(ChunkColorDataPacket.class, ChunkColorDataPacket.class, 0, Side.SERVER);
        INSTANCE.registerMessage(ChunkColorDataPacket.class, ChunkColorDataPacket.class, 0, Side.CLIENT);
        try {
            methodGetValueArray = NibbleArray.class.getMethod("getValueArray", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            FMLLog.info((String)"Unable to hook getValueArray, Ignore if not running cauldron", (Object[])new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public static void sendChunkColorData(Chunk chunk, EntityPlayerMP player) {
        try {
            ChunkColorDataPacket packet = new ChunkColorDataPacket(methodGetValueArray);
            NibbleArray[] redColorArray = ChunkStorageRGB.getRedColorArrays(chunk);
            NibbleArray[] greenColorArray = ChunkStorageRGB.getGreenColorArrays(chunk);
            NibbleArray[] blueColorArray = ChunkStorageRGB.getBlueColorArrays(chunk);
            if (redColorArray == null || greenColorArray == null || blueColorArray == null) {
                return;
            }
            packet.chunkXPosition = chunk.field_76635_g;
            packet.chunkZPosition = chunk.field_76647_h;
            packet.arraySize = redColorArray.length;
            packet.yLocation = ChunkStorageRGB.getYLocationArray(chunk);
            packet.RedColorArray = redColorArray;
            packet.GreenColorArray = greenColorArray;
            packet.BlueColorArray = blueColorArray;
            INSTANCE.sendTo((IMessage)packet, player);
        }
        catch (Exception e) {
            FMLLog.getLogger().warn("SendChunkColorData()  ", (Throwable)e);
        }
    }
}

