/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ChunkStorageRGB {
    private static String EVENT_SOURCE = "coloredlightscore.server.ChunkStorageRGB";
    private static Method methodSetRedColorArray = null;
    private static Method methodSetGreenColorArray = null;
    private static Method methodSetBlueColorArray = null;
    private static Method methodGetRedColorArray = null;
    private static Method methodGetGreenColorArray = null;
    private static Method methodGetBlueColorArray = null;
    private static Method methodGetValueArray = null;

    private static void getReflectionData() {
        if (methodSetRedColorArray == null) {
            for (Method m : ExtendedBlockStorage.class.getMethods()) {
                if (m.getName().equals("setRedColorArray")) {
                    methodSetRedColorArray = m;
                    continue;
                }
                if (m.getName().equals("setGreenColorArray")) {
                    methodSetGreenColorArray = m;
                    continue;
                }
                if (m.getName().equals("setBlueColorArray")) {
                    methodSetBlueColorArray = m;
                    continue;
                }
                if (m.getName().equals("getRedColorArray")) {
                    methodGetRedColorArray = m;
                    continue;
                }
                if (m.getName().equals("getGreenColorArray")) {
                    methodGetGreenColorArray = m;
                    continue;
                }
                if (!m.getName().equals("getBlueColorArray")) continue;
                methodGetBlueColorArray = m;
            }
            try {
                methodGetValueArray = NibbleArray.class.getMethod("getValueArray", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                FMLLog.info((String)"Unable to hook getValueArray, Ignore if not running cauldron", (Object[])new Object[0]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            if (methodSetRedColorArray == null) {
                FMLLog.severe((String)"%s.getReflectionData()   Unable to locate method setRedColorArray in ExtendedBlockStorage!", (Object[])new Object[]{EVENT_SOURCE});
            }
            if (methodSetGreenColorArray == null) {
                FMLLog.severe((String)"%s.getReflectionData()   Unable to locate method setGreenColorArray in ExtendedBlockStorage!", (Object[])new Object[]{EVENT_SOURCE});
            }
            if (methodSetBlueColorArray == null) {
                FMLLog.severe((String)"%s.getReflectionData()   Unable to locate method setBlueColorArray in ExtendedBlockStorage!", (Object[])new Object[]{EVENT_SOURCE});
            }
            if (methodGetRedColorArray == null) {
                FMLLog.severe((String)"%s.getReflectionData()   Unable to locate method getRedColorArray in ExtendedBlockStorage!", (Object[])new Object[]{EVENT_SOURCE});
            }
            if (methodGetGreenColorArray == null) {
                FMLLog.severe((String)"%s.getReflectionData()   Unable to locate method getGreenColorArray in ExtendedBlockStorage!", (Object[])new Object[]{EVENT_SOURCE});
            }
            if (methodGetBlueColorArray == null) {
                FMLLog.severe((String)"%s.getReflectionData()   Unable to locate method getBlueColorArray in ExtendedBlockStorage!", (Object[])new Object[]{EVENT_SOURCE});
            }
        }
    }

    private static NibbleArray checkedGetNibbleArray(byte[] rawdata) {
        if (rawdata.length == 0) {
            return new NibbleArray(4096, 4);
        }
        if (rawdata.length < 2048) {
            FMLLog.warning((String)"checkedGetNibbleArray: rawdata is too short: %s, expected 2048", (Object[])new Object[]{rawdata.length});
            return new NibbleArray(4096, 4);
        }
        return new NibbleArray(rawdata, 4);
    }

    public static boolean loadColorData(Chunk chunk, NBTTagCompound data) {
        ExtendedBlockStorage[] chunkStorageArrays = chunk.func_76587_i();
        NBTTagCompound level = data.func_74775_l("Level");
        NBTTagList nbttaglist = level.func_150295_c("Sections", 10);
        boolean foundColorData = false;
        ChunkStorageRGB.getReflectionData();
        for (int k = 0; k < nbttaglist.func_74745_c(); ++k) {
            NBTTagCompound nbtYCompound = nbttaglist.func_150305_b(k);
            if (chunkStorageArrays[k] == null || !nbtYCompound.func_74764_b("RedColorArray")) continue;
            NibbleArray rColorArray = ChunkStorageRGB.checkedGetNibbleArray(nbtYCompound.func_74770_j("RedColorArray"));
            NibbleArray gColorArray = ChunkStorageRGB.checkedGetNibbleArray(nbtYCompound.func_74770_j("GreenColorArray"));
            NibbleArray bColorArray = ChunkStorageRGB.checkedGetNibbleArray(nbtYCompound.func_74770_j("BlueColorArray"));
            try {
                methodSetRedColorArray.invoke((Object)chunkStorageArrays[k], rColorArray);
                methodSetGreenColorArray.invoke((Object)chunkStorageArrays[k], gColorArray);
                methodSetBlueColorArray.invoke((Object)chunkStorageArrays[k], bColorArray);
                foundColorData = true;
                continue;
            }
            catch (IllegalAccessException e) {
                FMLLog.severe((String)"%s.loadColorData()   Unexpected IllegalAccessException while setting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
            catch (IllegalArgumentException e) {
                FMLLog.severe((String)"%s.loadColorData()   Unexpected IllegalArgumentException while setting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
            catch (InvocationTargetException e) {
                FMLLog.severe((String)"%s.loadColorData()   Unexpected InvocationTargetException while setting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
        }
        return foundColorData;
    }

    public static boolean loadColorData(Chunk chunk, int arraySize, int[] yLocation, NibbleArray[] redColorData, NibbleArray[] greenColorData, NibbleArray[] blueColorData) {
        ExtendedBlockStorage[] chunkStorageArrays = chunk.func_76587_i();
        boolean foundColorData = false;
        ChunkStorageRGB.getReflectionData();
        for (int k = 0; k < arraySize; ++k) {
            if (chunkStorageArrays[k] == null) continue;
            if (chunkStorageArrays[k].func_76662_d() != yLocation[k]) {
                FMLLog.severe((String)"EBS DATA OUT OF SEQUENCE. Expected %s, got %s", (Object[])new Object[]{chunkStorageArrays[k].func_76662_d(), yLocation[k]});
            }
            try {
                NibbleArray rColorArray = redColorData[k];
                NibbleArray gColorArray = greenColorData[k];
                NibbleArray bColorArray = blueColorData[k];
                methodSetRedColorArray.invoke((Object)chunkStorageArrays[k], rColorArray);
                methodSetGreenColorArray.invoke((Object)chunkStorageArrays[k], gColorArray);
                methodSetBlueColorArray.invoke((Object)chunkStorageArrays[k], bColorArray);
                foundColorData = true;
                continue;
            }
            catch (IllegalAccessException e) {
                FMLLog.severe((String)"%s.loadColorData()   Unexpected IllegalAccessException while setting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
            catch (IllegalArgumentException e) {
                FMLLog.severe((String)"%s.loadColorData()   Unexpected IllegalArgumentException while setting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
            catch (InvocationTargetException e) {
                FMLLog.severe((String)"%s.loadColorData()   Unexpected InvocationTargetException while setting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
            catch (Exception e) {
                FMLLog.getLogger().error("loadColorData()  ", (Throwable)e);
            }
        }
        return foundColorData;
    }

    public static boolean saveColorData(Chunk chunk, NBTTagCompound data) {
        ExtendedBlockStorage[] chunkStorageArrays = chunk.func_76587_i();
        NBTTagCompound level = data.func_74775_l("Level");
        NBTTagList nbttaglist = level.func_150295_c("Sections", 10);
        ChunkStorageRGB.getReflectionData();
        for (int k = 0; k < chunkStorageArrays.length; ++k) {
            if (chunkStorageArrays[k] == null) continue;
            NBTTagCompound nbtYCompound = nbttaglist.func_150305_b(k);
            try {
                NibbleArray rColorArray = (NibbleArray)methodGetRedColorArray.invoke((Object)chunkStorageArrays[k], new Object[0]);
                NibbleArray gColorArray = (NibbleArray)methodGetGreenColorArray.invoke((Object)chunkStorageArrays[k], new Object[0]);
                NibbleArray bColorArray = (NibbleArray)methodGetBlueColorArray.invoke((Object)chunkStorageArrays[k], new Object[0]);
                if (FMLCommonHandler.instance().getModName().contains("cauldron")) {
                    nbtYCompound.func_74773_a("RedColorArray", (byte[])methodGetValueArray.invoke((Object)rColorArray, new Object[0]));
                    nbtYCompound.func_74773_a("GreenColorArray", (byte[])methodGetValueArray.invoke((Object)gColorArray, new Object[0]));
                    nbtYCompound.func_74773_a("BlueColorArray", (byte[])methodGetValueArray.invoke((Object)bColorArray, new Object[0]));
                    continue;
                }
                nbtYCompound.func_74773_a("RedColorArray", rColorArray.field_76585_a);
                nbtYCompound.func_74773_a("GreenColorArray", gColorArray.field_76585_a);
                nbtYCompound.func_74773_a("BlueColorArray", bColorArray.field_76585_a);
                continue;
            }
            catch (IllegalAccessException e) {
                FMLLog.severe((String)"%s.saveColorData()   Unexpected IllegalAccessException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
            catch (IllegalArgumentException e) {
                FMLLog.severe((String)"%s.saveColorData()   Unexpected IllegalArgumentException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
            catch (InvocationTargetException e) {
                FMLLog.severe((String)"%s.saveColorData()   Unexpected InvocationTargetException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
            catch (Exception e) {
                FMLLog.severe((String)"%s.saveColorData()   Unexpected Exception while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return false;
            }
        }
        return true;
    }

    public static NibbleArray[] getRedColorArrays(Chunk chunk) {
        ExtendedBlockStorage[] chunkStorageArrays = chunk.func_76587_i();
        ChunkStorageRGB.getReflectionData();
        NibbleArray[] redColorArrays = new NibbleArray[chunkStorageArrays.length];
        for (int i = 0; i < chunkStorageArrays.length; ++i) {
            try {
                if (chunkStorageArrays[i] != null) {
                    redColorArrays[i] = (NibbleArray)methodGetRedColorArray.invoke((Object)chunkStorageArrays[i], new Object[0]);
                    continue;
                }
                redColorArrays[i] = null;
                continue;
            }
            catch (IllegalAccessException e) {
                FMLLog.severe((String)"%s.getRedColorArrays()   Unexpected IllegalAccessException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (IllegalArgumentException e) {
                FMLLog.severe((String)"%s.getRedColorArrays()   Unexpected IllegalArgumentException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (InvocationTargetException e) {
                FMLLog.severe((String)"%s.getRedColorArrays()   Unexpected InvocationTargetException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (Exception e) {
                FMLLog.severe((String)"%s.getRedColorArrays()   Unexpected Exception while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
        }
        return redColorArrays;
    }

    public static NibbleArray[] getGreenColorArrays(Chunk chunk) {
        ExtendedBlockStorage[] chunkStorageArrays = chunk.func_76587_i();
        ChunkStorageRGB.getReflectionData();
        NibbleArray[] greenColorArrays = new NibbleArray[chunkStorageArrays.length];
        for (int i = 0; i < chunkStorageArrays.length; ++i) {
            try {
                if (chunkStorageArrays[i] != null) {
                    greenColorArrays[i] = (NibbleArray)methodGetGreenColorArray.invoke((Object)chunkStorageArrays[i], new Object[0]);
                    continue;
                }
                greenColorArrays[i] = null;
                continue;
            }
            catch (IllegalAccessException e) {
                FMLLog.severe((String)"%s.getGreenColorArrays()   Unexpected IllegalAccessException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (IllegalArgumentException e) {
                FMLLog.severe((String)"%s.getGreenColorArrays()   Unexpected IllegalArgumentException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (InvocationTargetException e) {
                FMLLog.severe((String)"%s.getGreenColorArrays()   Unexpected InvocationTargetException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (Exception e) {
                FMLLog.severe((String)"%s.getGreenColorArrays()   Unexpected Exception while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
        }
        return greenColorArrays;
    }

    public static NibbleArray[] getBlueColorArrays(Chunk chunk) {
        ExtendedBlockStorage[] chunkStorageArrays = chunk.func_76587_i();
        ChunkStorageRGB.getReflectionData();
        NibbleArray[] blueColorArrays = new NibbleArray[chunkStorageArrays.length];
        for (int i = 0; i < chunkStorageArrays.length; ++i) {
            try {
                if (chunkStorageArrays[i] != null) {
                    blueColorArrays[i] = (NibbleArray)methodGetBlueColorArray.invoke((Object)chunkStorageArrays[i], new Object[0]);
                    continue;
                }
                blueColorArrays[i] = null;
                continue;
            }
            catch (IllegalAccessException e) {
                FMLLog.severe((String)"%s.getBlueColorArrays()   Unexpected IllegalAccessException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (IllegalArgumentException e) {
                FMLLog.severe((String)"%s.getBlueColorArrays()   Unexpected IllegalArgumentException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (InvocationTargetException e) {
                FMLLog.severe((String)"%s.getBlueColorArrays()   Unexpected InvocationTargetException while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
            catch (Exception e) {
                FMLLog.severe((String)"%s.getBlueColorArrays()   Unexpected Exception while getting RGB color data!", (Object[])new Object[]{EVENT_SOURCE});
                return null;
            }
        }
        return blueColorArrays;
    }

    public static int[] getYLocationArray(Chunk chunk) {
        ExtendedBlockStorage[] ebs = chunk.func_76587_i();
        int[] y = new int[ebs.length];
        for (int i = 0; i < ebs.length; ++i) {
            y[i] = ebs[i] == null ? -1 : ebs[i].func_76662_d();
        }
        return y;
    }
}

