/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.api;

import cpw.mods.fml.common.FMLLog;
import java.util.Random;
import net.minecraft.block.Block;

public class CLApi {
    public static float[] l = new float[]{0.0f, 0.06666667f, 0.13333334f, 0.2f, 0.26666668f, 0.33333334f, 0.4f, 0.46666667f, 0.53333336f, 0.6f, 0.6666667f, 0.73333335f, 0.8f, 0.8666667f, 0.93333334f, 1.0f};
    public static int[] r = new int[]{0, 15, 0, 8, 0, 10, 0, 10, 5, 15, 8, 15, 0, 15, 15, 15};
    public static int[] g = new int[]{0, 0, 15, 3, 0, 0, 15, 10, 5, 10, 15, 15, 8, 0, 12, 15};
    public static int[] b = new int[]{0, 0, 0, 0, 15, 15, 15, 10, 5, 13, 0, 0, 15, 15, 10, 15};
    public static Random rand = new Random();

    public static int makeRGBLightValue(float r, float g, float b, float currentLightValue) {
        if (r < 0.0f) {
            r = 0.0f;
        } else if (r > 1.0f) {
            r = 1.0f;
        }
        if (g < 0.0f) {
            g = 0.0f;
        } else if (g > 1.0f) {
            g = 1.0f;
        }
        if (b < 0.0f) {
            b = 0.0f;
        } else if (b > 1.0f) {
            b = 1.0f;
        }
        int brightness = (int)(currentLightValue * 15.0f);
        return (brightness &= 0xF) | ((int)(15.0f * b) << 15) + ((int)(15.0f * g) << 10) + ((int)(15.0f * r) << 5);
    }

    public static int makeRGBLightValue(int r, int g, int b, int brightness) {
        if (r < 0) {
            r = 0;
        } else if (r > 15) {
            r = 15;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 15) {
            g = 15;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 15) {
            b = 15;
        }
        if ((brightness &= 0xF) != Math.max(r, Math.max(g, b))) {
            FMLLog.warning((String)"One of the color value should be equal to Current Light Brightness, but not exceed it", (Object[])new Object[0]);
            FMLLog.warning((String)("r: " + r + "  g: " + g + "  b: " + b + "  l: " + brightness), (Object[])new Object[0]);
        }
        return brightness | (b << 15) + (g << 10) + (r << 5);
    }

    public static int makeRGBLightValue(float r, float g, float b) {
        if (r < 0.0f) {
            r = 0.0f;
        } else if (r > 1.0f) {
            r = 1.0f;
        }
        if (g < 0.0f) {
            g = 0.0f;
        } else if (g > 1.0f) {
            g = 1.0f;
        }
        if (b < 0.0f) {
            b = 0.0f;
        } else if (b > 1.0f) {
            b = 1.0f;
        }
        int brightness = (int)(15.0f * Math.max(Math.max(r, g), b));
        return brightness | ((int)(15.0f * b) << 15) + ((int)(15.0f * g) << 10) + ((int)(15.0f * r) << 5);
    }

    public static int makeRGBLightValue(int r, int g, int b) {
        if (r < 0) {
            r = 0;
        } else if (r > 15) {
            r = 15;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 15) {
            g = 15;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 15) {
            b = 15;
        }
        int brightness = Math.max(Math.max(r, g), b);
        return brightness | (b << 15) + (g << 10) + (r << 5);
    }

    public static Block setBlockColorRGB(Block block, int r, int g, int b, int lightValue) {
        block.field_149784_t = CLApi.makeRGBLightValue(r, g, b, lightValue);
        return block;
    }

    public static Block setBlockColorRGB(Block block, float r, float g, float b, float lightValue) {
        block.field_149784_t = CLApi.makeRGBLightValue(r, g, b, lightValue);
        return block;
    }

    public static Block setBlockColorRGB(Block block, int r, int g, int b) {
        block.field_149784_t = CLApi.makeRGBLightValue(r, g, b, block.field_149784_t);
        return block;
    }

    public static Block setBlockColorRGB(Block block, float r, float g, float b) {
        block.field_149784_t = CLApi.makeRGBLightValue(r, g, b, (float)block.field_149784_t / 15.0f);
        return block;
    }
}

