/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer;

import coloredlightscore.src.asm.ColoredLightsCoreLoadingPlugin;
import coloredlightscore.src.asm.transformer.core.HelperMethodTransformer;
import coloredlightscore.src.asm.transformer.core.NameMapper;
import coloredlightscore.src.helper.CLEntityRendererHelper;
import cpw.mods.fml.common.FMLLog;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TransformEntityRenderer
extends HelperMethodTransformer {
    String[] methodsToReplace = new String[]{"updateLightmap (F)V", "enableLightmap (D)V", "disableLightmap (D)V"};
    String entityRendererConstructor = "<init> (Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/resources/IResourceManager;)V";
    String obfEntityRendererConstructor = "<init> (Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/resources/IResourceManager;)V";
    String oldLightmapDesc = "net/minecraft/client/renderer/texture/DynamicTexture";
    String obfOldLightmapDesc = "net/minecraft/client/renderer/texture/DynamicTexture";
    String entityRenderClass = "net/minecraft/client/renderer/EntityRenderer";
    String obfEntityRenderClass = "net/minecraft/client/renderer/EntityRenderer";
    String new3DDesc = "coloredlightscore/src/types/CLDynamicTexture3D";
    String new2DDesc = "coloredlightscore/src/types/CLDynamicTexture2D";
    boolean addSetterAndInterface = false;

    public TransformEntityRenderer() {
        super("net.minecraft.client.renderer.EntityRenderer");
    }

    @Override
    protected Class<?> getHelperClass() {
        return CLEntityRendererHelper.class;
    }

    @Override
    protected boolean transforms(ClassNode classNode, MethodNode methodNode) {
        for (String name : this.methodsToReplace) {
            if (!NameMapper.getInstance().isMethod(methodNode, this.className, name)) continue;
            return true;
        }
        return (methodNode.name + " " + methodNode.desc).equals(this.entityRendererConstructor) || (methodNode.name + " " + methodNode.desc).equals(this.obfEntityRendererConstructor);
    }

    @Override
    public boolean preTransformClass(ClassNode classNode) {
        if (!ColoredLightsCoreLoadingPlugin.MCP_ENVIRONMENT) {
            this.oldLightmapDesc = this.obfOldLightmapDesc;
            this.entityRenderClass = this.obfEntityRenderClass;
        }
        if (!this.addSetterAndInterface) {
            classNode.interfaces.add("coloredlightscore/src/types/CLEntityRendererInterface");
            classNode.fields.add(new FieldNode(1, "lightmapTexture2", "L" + this.oldLightmapDesc + ";", null, null));
            classNode.fields.add(new FieldNode(1, "lightmapTexture3", "L" + this.oldLightmapDesc + ";", null, null));
            MethodNode getter1 = new MethodNode(1, "getLightmapTexture2", "()L" + this.new3DDesc + ";", null, null);
            getter1.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            getter1.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "lightmapTexture2", "L" + this.oldLightmapDesc + ";"));
            getter1.instructions.add((AbstractInsnNode)new TypeInsnNode(192, this.new3DDesc));
            getter1.instructions.add((AbstractInsnNode)new InsnNode(176));
            classNode.methods.add(getter1);
            MethodNode getter2 = new MethodNode(1, "getLightmapTexture3", "()L" + this.new2DDesc + ";", null, null);
            getter2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            getter2.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "lightmapTexture3", "L" + this.oldLightmapDesc + ";"));
            getter2.instructions.add((AbstractInsnNode)new TypeInsnNode(192, this.new2DDesc));
            getter2.instructions.add((AbstractInsnNode)new InsnNode(176));
            classNode.methods.add(getter2);
            MethodNode setter = new MethodNode(1, "setLightmapTexture", "([I)V", null, null);
            setter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (ColoredLightsCoreLoadingPlugin.MCP_ENVIRONMENT) {
                setter.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "lightmapTexture", "L" + this.oldLightmapDesc + ";"));
            } else {
                setter.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "field_78513_d", "L" + this.oldLightmapDesc + ";"));
            }
            setter.instructions.add((AbstractInsnNode)new TypeInsnNode(192, this.new3DDesc));
            setter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            if (ColoredLightsCoreLoadingPlugin.MCP_ENVIRONMENT) {
                setter.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.new3DDesc, "dynamicTextureData", "[I"));
            } else {
                setter.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.new3DDesc, "field_110566_b", "[I"));
            }
            setter.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(setter);
            this.addSetterAndInterface = true;
        }
        return true;
    }

    @Override
    protected boolean transform(ClassNode classNode, MethodNode methodNode) {
        for (String name : this.methodsToReplace) {
            if (!NameMapper.getInstance().isMethod(methodNode, this.className, name)) continue;
            return this.redefineMethod(classNode, methodNode, name);
        }
        if ((methodNode.name + " " + methodNode.desc).equals(this.entityRendererConstructor) || (methodNode.name + " " + methodNode.desc).equals(this.obfEntityRendererConstructor)) {
            return this.transformConstructor(methodNode);
        }
        return false;
    }

    protected boolean transformConstructor(MethodNode methodNode) {
        if (!ColoredLightsCoreLoadingPlugin.MCP_ENVIRONMENT) {
            this.oldLightmapDesc = this.obfOldLightmapDesc;
            this.entityRenderClass = this.obfEntityRenderClass;
        }
        boolean found2DLightmap = false;
        boolean add3DLightmap = false;
        boolean removeTextureLocation = false;
        ListIterator it = methodNode.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (insn.getOpcode() == 187 && !found2DLightmap && ((TypeInsnNode)insn).desc.equals(this.oldLightmapDesc)) {
                FMLLog.info((String)"Replacing 2D lighmap texture", (Object[])new Object[0]);
                ((TypeInsnNode)insn).desc = this.new3DDesc;
                insn = (AbstractInsnNode)it.next();
                insn = (AbstractInsnNode)it.next();
                insn = (AbstractInsnNode)it.next();
                it.add(new IntInsnNode(16, 16));
                FMLLog.info((String)("Setting Entityrenderer.lightmapTexture to a " + this.new3DDesc), (Object[])new Object[0]);
                insn = (AbstractInsnNode)it.next();
                ((MethodInsnNode)insn).owner = this.new3DDesc;
                ((MethodInsnNode)insn).name = "<init>";
                ((MethodInsnNode)insn).desc = "(III)V";
                insn = (AbstractInsnNode)it.next();
                found2DLightmap = true;
            }
            if (!removeTextureLocation && found2DLightmap) {
                FMLLog.info((String)"Removing locationLightMap", (Object[])new Object[0]);
                for (int i = 0; i < 10; ++i) {
                    insn = (AbstractInsnNode)it.next();
                    it.remove();
                }
                removeTextureLocation = true;
            }
            if (add3DLightmap || !removeTextureLocation || !found2DLightmap) continue;
            FMLLog.info((String)"Adding Second Colormap", (Object[])new Object[0]);
            it.add(new VarInsnNode(25, 0));
            it.add(new TypeInsnNode(187, this.new3DDesc));
            it.add(new InsnNode(89));
            it.add(new IntInsnNode(16, 16));
            it.add(new IntInsnNode(16, 16));
            it.add(new IntInsnNode(16, 16));
            it.add(new MethodInsnNode(183, this.new3DDesc, "<init>", "(III)V"));
            it.add(new FieldInsnNode(181, this.entityRenderClass, "lightmapTexture2", "L" + this.oldLightmapDesc + ";"));
            FMLLog.info((String)"Adding Third Empty Texture", (Object[])new Object[0]);
            it.add(new VarInsnNode(25, 0));
            it.add(new TypeInsnNode(187, this.new2DDesc));
            it.add(new InsnNode(89));
            it.add(new IntInsnNode(16, 16));
            it.add(new IntInsnNode(16, 16));
            it.add(new MethodInsnNode(183, this.new2DDesc, "<init>", "(II)V"));
            it.add(new FieldInsnNode(181, this.entityRenderClass, "lightmapTexture3", "L" + this.oldLightmapDesc + ";"));
            add3DLightmap = true;
        }
        return found2DLightmap && removeTextureLocation && add3DLightmap;
    }
}

