/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer;

import coloredlightscore.src.asm.ColoredLightsCoreDummyContainer;
import coloredlightscore.src.asm.transformer.core.ASMUtils;
import coloredlightscore.src.asm.transformer.core.MethodTransformer;
import coloredlightscore.src.asm.transformer.core.NameMapper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TransformExtendedBlockStorage
extends MethodTransformer {
    private boolean addedFields = false;
    private FieldNode rColorArray;
    private FieldNode gColorArray;
    private FieldNode bColorArray;
    private FieldNode blockLSBArray;
    private final String NIBBLE_ARRAY = "Lnet.minecraft.world.chunk.NibbleArray;";
    private final String EBS_CLASSNAME = "net.minecraft.world.chunk.storage.ExtendedBlockStorage";
    private final String SET_BLOCK_LIGHT_VALUE = "setExtBlocklightValue (IIII)V";
    private final String GET_BLOCK_LIGHT_VALUE = "getExtBlocklightValue (III)I";
    private boolean addedMethods = false;

    @Override
    protected boolean transforms(ClassNode clazz, MethodNode method) {
        return NameMapper.getInstance().isMethod(method, "net.minecraft.world.chunk.storage.ExtendedBlockStorage", "setExtBlocklightValue (IIII)V") | NameMapper.getInstance().isMethod(method, "net.minecraft.world.chunk.storage.ExtendedBlockStorage", "getExtBlocklightValue (III)I") | method.name.equals("<init>");
    }

    @Override
    protected boolean transform(ClassNode clazz, MethodNode method) {
        boolean changed = false;
        if (!this.addedFields) {
            this.addRGBNibbleArrays(clazz);
            changed = true;
        }
        if (NameMapper.getInstance().isMethod(method, "net.minecraft.world.chunk.storage.ExtendedBlockStorage", "setExtBlocklightValue (IIII)V")) {
            this.transformSetExtBlocklightValue(clazz, method);
            changed = true;
        }
        if (NameMapper.getInstance().isMethod(method, "net.minecraft.world.chunk.storage.ExtendedBlockStorage", "getExtBlocklightValue (III)I")) {
            this.transformGetExtBlocklightValue(clazz, method);
            changed = true;
        }
        if (method.name.equals("<init>")) {
            this.transformConstructor(clazz, method);
            changed = true;
        }
        return changed;
    }

    @Override
    protected boolean postTransformClass(ClassNode clazz) {
        if (!this.addedMethods) {
            this.addRGBNibbleArrayMethods(clazz);
            return true;
        }
        return false;
    }

    @Override
    protected boolean transforms(String className) {
        return className.equals("net.minecraft.world.chunk.storage.ExtendedBlockStorage");
    }

    private void addRGBNibbleArrays(ClassNode clazz) {
        Type typeNibbleArray = NameMapper.getInstance().getType("Lnet.minecraft.world.chunk.NibbleArray;");
        for (FieldNode f : clazz.fields) {
            if (!f.name.equals("blockLSBArray") && !f.name.equals("field_76680_d") && (!f.name.equals("d") || !f.desc.equals("[B"))) continue;
            this.blockLSBArray = f;
        }
        if (this.blockLSBArray == null) {
            ColoredLightsCoreDummyContainer.CLLog.error("TransformExtendedBlockStorage: Failed to find blockLSBArray!");
        }
        this.rColorArray = new FieldNode(1, "rColorArray", typeNibbleArray.getDescriptor(), null, null);
        this.gColorArray = new FieldNode(1, "gColorArray", typeNibbleArray.getDescriptor(), null, null);
        this.bColorArray = new FieldNode(1, "bColorArray", typeNibbleArray.getDescriptor(), null, null);
        clazz.fields.add(this.rColorArray);
        clazz.fields.add(this.gColorArray);
        clazz.fields.add(this.bColorArray);
        ColoredLightsCoreDummyContainer.CLLog.info("Added RGB color arrays to ExtendedBlockStorage, type " + typeNibbleArray.getDescriptor());
        this.addedFields = true;
    }

    private boolean addRGBNibbleArrayMethods(ClassNode clazz) {
        if (this.addedFields && !this.addedMethods) {
            clazz.methods.add(ASMUtils.generateSetterMethod(clazz.name, "setRedColorArray", this.rColorArray.name, this.rColorArray.desc));
            clazz.methods.add(ASMUtils.generateSetterMethod(clazz.name, "setGreenColorArray", this.gColorArray.name, this.gColorArray.desc));
            clazz.methods.add(ASMUtils.generateSetterMethod(clazz.name, "setBlueColorArray", this.bColorArray.name, this.bColorArray.desc));
            clazz.methods.add(ASMUtils.generateGetterMethod(clazz.name, "getRedColorArray", this.rColorArray.name, this.rColorArray.desc));
            clazz.methods.add(ASMUtils.generateGetterMethod(clazz.name, "getGreenColorArray", this.gColorArray.name, this.gColorArray.desc));
            clazz.methods.add(ASMUtils.generateGetterMethod(clazz.name, "getBlueColorArray", this.bColorArray.name, this.bColorArray.desc));
            this.addedMethods = true;
        }
        return this.addedMethods;
    }

    private void transformConstructor(ClassNode clazz, MethodNode m) {
        String ebsInternalName = clazz.name;
        Type typeNibbleArray = NameMapper.getInstance().getType("Lnet.minecraft.world.chunk.NibbleArray;");
        AbstractInsnNode returnNode = ASMUtils.findLastReturn(m);
        if (returnNode == null) {
            ColoredLightsCoreDummyContainer.CLLog.error(String.format("Failed to find RETURN statement on %s/%s %s", clazz.name, m.name, m.desc));
        } else {
            m.instructions.remove(returnNode);
        }
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new TypeInsnNode(187, typeNibbleArray.getInternalName()));
        m.instructions.add((AbstractInsnNode)new InsnNode(89));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.blockLSBArray.name, this.blockLSBArray.desc));
        m.instructions.add((AbstractInsnNode)new InsnNode(190));
        m.instructions.add((AbstractInsnNode)new InsnNode(7));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, typeNibbleArray.getInternalName(), "<init>", "(II)V"));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(181, ebsInternalName, this.rColorArray.name, this.rColorArray.desc));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new TypeInsnNode(187, typeNibbleArray.getInternalName()));
        m.instructions.add((AbstractInsnNode)new InsnNode(89));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.blockLSBArray.name, this.blockLSBArray.desc));
        m.instructions.add((AbstractInsnNode)new InsnNode(190));
        m.instructions.add((AbstractInsnNode)new InsnNode(7));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, typeNibbleArray.getInternalName(), "<init>", "(II)V"));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(181, ebsInternalName, this.gColorArray.name, this.gColorArray.desc));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new TypeInsnNode(187, typeNibbleArray.getInternalName()));
        m.instructions.add((AbstractInsnNode)new InsnNode(89));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.blockLSBArray.name, this.blockLSBArray.desc));
        m.instructions.add((AbstractInsnNode)new InsnNode(190));
        m.instructions.add((AbstractInsnNode)new InsnNode(7));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, typeNibbleArray.getInternalName(), "<init>", "(II)V"));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(181, ebsInternalName, this.bColorArray.name, this.bColorArray.desc));
        m.instructions.add(returnNode);
    }

    private void transformSetExtBlocklightValue(ClassNode clazz, MethodNode m) {
        String ebsInternalName = clazz.name;
        Type typeNibbleArray = NameMapper.getInstance().getType("Lnet.minecraft.world.chunk.NibbleArray;");
        String nibbleArraySet = NameMapper.getInstance().getMethodName("net/minecraft/world/chunk/NibbleArray", "set (IIII)V");
        AbstractInsnNode oldReturn = ASMUtils.findLastReturn(m);
        if (oldReturn != null) {
            m.instructions.remove(oldReturn);
        }
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.rColorArray.name, this.rColorArray.desc));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
        m.instructions.add((AbstractInsnNode)new InsnNode(8));
        m.instructions.add((AbstractInsnNode)new InsnNode(122));
        m.instructions.add((AbstractInsnNode)new IntInsnNode(16, 15));
        m.instructions.add((AbstractInsnNode)new InsnNode(126));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, typeNibbleArray.getInternalName(), nibbleArraySet, "(IIII)V"));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.gColorArray.name, this.gColorArray.desc));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
        m.instructions.add((AbstractInsnNode)new IntInsnNode(16, 10));
        m.instructions.add((AbstractInsnNode)new InsnNode(122));
        m.instructions.add((AbstractInsnNode)new IntInsnNode(16, 15));
        m.instructions.add((AbstractInsnNode)new InsnNode(126));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, typeNibbleArray.getInternalName(), nibbleArraySet, "(IIII)V"));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.bColorArray.name, this.bColorArray.desc));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
        m.instructions.add((AbstractInsnNode)new IntInsnNode(16, 15));
        m.instructions.add((AbstractInsnNode)new InsnNode(122));
        m.instructions.add((AbstractInsnNode)new IntInsnNode(16, 15));
        m.instructions.add((AbstractInsnNode)new InsnNode(126));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, typeNibbleArray.getInternalName(), nibbleArraySet, "(IIII)V"));
        m.instructions.add((AbstractInsnNode)new InsnNode(177));
    }

    private void transformGetExtBlocklightValue(ClassNode clazz, MethodNode m) {
        String ebsInternalName = clazz.name;
        Type typeNibbleArray = NameMapper.getInstance().getType("Lnet.minecraft.world.chunk.NibbleArray;");
        String nibbleArrayGet = NameMapper.getInstance().getMethodName("net/minecraft/world/chunk/NibbleArray", "get (III)I");
        AbstractInsnNode returnNode = ASMUtils.findLastReturn(m);
        if (returnNode != null) {
            m.instructions.remove(returnNode);
        }
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.rColorArray.name, this.rColorArray.desc));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, typeNibbleArray.getInternalName(), nibbleArrayGet, "(III)I"));
        m.instructions.add((AbstractInsnNode)new InsnNode(8));
        m.instructions.add((AbstractInsnNode)new InsnNode(120));
        m.instructions.add((AbstractInsnNode)new InsnNode(128));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.gColorArray.name, this.gColorArray.desc));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, typeNibbleArray.getInternalName(), nibbleArrayGet, "(III)I"));
        m.instructions.add((AbstractInsnNode)new IntInsnNode(16, 10));
        m.instructions.add((AbstractInsnNode)new InsnNode(120));
        m.instructions.add((AbstractInsnNode)new InsnNode(128));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, ebsInternalName, this.bColorArray.name, this.bColorArray.desc));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, typeNibbleArray.getInternalName(), nibbleArrayGet, "(III)I"));
        m.instructions.add((AbstractInsnNode)new IntInsnNode(16, 15));
        m.instructions.add((AbstractInsnNode)new InsnNode(120));
        m.instructions.add((AbstractInsnNode)new InsnNode(128));
        if (returnNode != null) {
            m.instructions.add(returnNode);
        }
    }
}

