/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer;

import coloredlightscore.src.asm.ColoredLightsCoreDummyContainer;
import coloredlightscore.src.asm.transformer.core.ASMUtils;
import coloredlightscore.src.asm.transformer.core.MethodTransformer;
import coloredlightscore.src.asm.transformer.core.NameMapper;
import cpw.mods.fml.common.FMLLog;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TransformPlayerInstance
extends MethodTransformer {
    private final String PLAYER_INSTANCE_CLASSNAME = "net.minecraft.server.management.PlayerManager$PlayerInstance";
    private final String SEND_TO_ALL_PLAYERS_WATCHING_CHUNK = "sendToAllPlayersWatchingChunk (Lnet/minecraft/network/Packet;)V";

    @Override
    protected boolean transforms(ClassNode clazz, MethodNode method) {
        return NameMapper.getInstance().isMethod(method, "net.minecraft.server.management.PlayerManager$PlayerInstance", "sendToAllPlayersWatchingChunk (Lnet/minecraft/network/Packet;)V");
    }

    @Override
    protected boolean transform(ClassNode clazz, MethodNode method) {
        if (NameMapper.getInstance().isMethod(method, "net.minecraft.server.management.PlayerManager$PlayerInstance", "sendToAllPlayersWatchingChunk (Lnet/minecraft/network/Packet;)V")) {
            this.transformNewSendToAllPlayersWatchingChunk(method);
            return true;
        }
        return false;
    }

    @Override
    protected boolean transforms(String className) {
        return className.equals("net.minecraft.server.management.PlayerManager$PlayerInstance");
    }

    protected void transformNewSendToAllPlayersWatchingChunk(MethodNode method) {
        MethodInsnNode insertionPoint = ASMUtils.findLastInvoke(method, 182, "net/minecraft/network/NetHandlerPlayServer", "sendPacket (Lnet/minecraft/network/Packet;)V", false);
        InsnList helperInvoke = new InsnList();
        String playerInstance = NameMapper.getInstance().getClassName("net.minecraft.server.management.PlayerManager$PlayerInstance");
        String chunkLocation = NameMapper.getInstance().getClassField("net.minecraft.server.management.PlayerManager$PlayerInstance", "chunkLocation");
        String chunkLocationDescriptor = NameMapper.getInstance().getJVMTypeObfuscated("Lnet/minecraft/world/ChunkCoordIntPair;");
        String helperDescriptor = NameMapper.getInstance().getJVMTypeObfuscated("(Lnet/minecraft/entity/player/EntityPlayerMP;Lnet/minecraft/world/ChunkCoordIntPair;)V");
        FMLLog.info((String)"debug->field name is %s", (Object[])new Object[]{chunkLocation});
        helperInvoke.add((AbstractInsnNode)new VarInsnNode(25, 3));
        helperInvoke.add((AbstractInsnNode)new VarInsnNode(25, 0));
        helperInvoke.add((AbstractInsnNode)new FieldInsnNode(180, playerInstance, chunkLocation, chunkLocationDescriptor));
        helperInvoke.add((AbstractInsnNode)new MethodInsnNode(184, "coloredlightscore/server/PlayerManagerHelper", "sendToPlayerWatchingChunk", helperDescriptor));
        if (insertionPoint != null) {
            method.instructions.insert((AbstractInsnNode)insertionPoint, helperInvoke);
        } else {
            ColoredLightsCoreDummyContainer.CLLog.error("TransformPlayerInstance.transformNewSendToAllPlayersWatchingChunk()  Could not find last invoke of sendPacket!");
            ASMUtils.findLastInvoke(method, 182, "net/minecraft/network/NetHandlerPlayServer", "sendPacket (Lnet/minecraft/network/Packet;)V", true);
        }
    }
}

