/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer;

import coloredlightscore.src.asm.transformer.core.HelperMethodTransformer;
import coloredlightscore.src.asm.transformer.core.NameMapper;
import coloredlightscore.src.helper.CLRenderBlocksHelper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class TransformRenderBlocks
extends HelperMethodTransformer {
    String[] methodsToReplace = new String[]{"renderStandardBlockWithAmbientOcclusion (Lnet/minecraft/block/Block;IIIFFF)Z", "renderStandardBlockWithColorMultiplier (Lnet/minecraft/block/Block;IIIFFF)Z", "getAoBrightness (IIII)I"};

    public TransformRenderBlocks() {
        super("net.minecraft.client.renderer.RenderBlocks");
    }

    @Override
    protected Class<?> getHelperClass() {
        return CLRenderBlocksHelper.class;
    }

    @Override
    protected boolean transforms(ClassNode classNode, MethodNode methodNode) {
        for (String name : this.methodsToReplace) {
            if (!NameMapper.getInstance().isMethod(methodNode, this.className, name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean transform(ClassNode classNode, MethodNode methodNode) {
        for (String name : this.methodsToReplace) {
            if (!NameMapper.getInstance().isMethod(methodNode, this.className, name)) continue;
            return this.redefineMethod(classNode, methodNode, name);
        }
        return false;
    }
}

