/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer;

import coloredlightscore.src.asm.transformer.core.ASMUtils;
import coloredlightscore.src.asm.transformer.core.ExtendedClassWriter;
import coloredlightscore.src.asm.transformer.core.HelperMethodTransformer;
import coloredlightscore.src.asm.transformer.core.NameMapper;
import coloredlightscore.src.helper.CLTessellatorHelper;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import java.util.ListIterator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TransformTessellator
extends HelperMethodTransformer {
    String unObfBrightness = "hasBrightness";
    String obfBrightness = "field_78414_p";
    String unObfLightmapTexUnit = "lightmapTexUnit";
    String obfLightmapTexUnit = "field_77476_b";
    String unObfDefaultTexUnit = "defaultTexUnit";
    String obfDefaultTexUnit = "field_77478_a";
    String[] methodsToReplace = new String[]{"addVertex (DDD)V"};

    public TransformTessellator() {
        super("net/minecraft/client/renderer/Tessellator");
    }

    @Override
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes != null && this.transforms(transformedName)) {
            FMLLog.info((String)"Class %s is a candidate for transforming", (Object[])new Object[]{transformedName});
            try {
                ClassNode clazz = ASMUtils.getClassNode(bytes);
                if (this.transform(clazz, transformedName)) {
                    FMLLog.info((String)("Finished Transforming class " + transformedName), (Object[])new Object[0]);
                    ExtendedClassWriter writer = new ExtendedClassWriter(3);
                    clazz.accept((ClassVisitor)writer);
                    bytes = writer.toByteArray();
                } else {
                    FMLLog.warning((String)"Did not transform %s", (Object[])new Object[]{transformedName});
                }
            }
            catch (Exception e) {
                FMLLog.severe((String)("Exception during transformation of class " + transformedName), (Object[])new Object[0]);
                e.printStackTrace();
                Throwables.propagate((Throwable)e);
            }
        }
        return bytes;
    }

    @Override
    public boolean preTransformClass(ClassNode classNode) {
        classNode.interfaces.add("coloredlightscore/src/types/CLTessellatorInterface");
        MethodNode getter = new MethodNode(1, "getRawBufferSize", "()I", null, null);
        getter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        getter.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "rawBufferSize", "I"));
        getter.instructions.add((AbstractInsnNode)new InsnNode(172));
        classNode.methods.add(getter);
        MethodNode setter = new MethodNode(1, "setRawBufferSize", "(I)V", null, null);
        setter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        setter.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        setter.instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, "rawBufferSize", "I"));
        setter.instructions.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(setter);
        return true;
    }

    @Override
    protected Class<?> getHelperClass() {
        return CLTessellatorHelper.class;
    }

    @Override
    protected boolean transforms(ClassNode classNode, MethodNode methodNode) {
        for (String name : this.methodsToReplace) {
            if (!NameMapper.getInstance().isMethod(methodNode, this.className, name)) continue;
            return true;
        }
        if ((methodNode.name + " " + methodNode.desc).equals(NameMapper.drawSignature) || (methodNode.name + " " + methodNode.desc).equals(NameMapper.obfDrawSignature)) {
            return true;
        }
        return (methodNode.name + " " + methodNode.desc).equals(NameMapper.getVertexStateSignature) || (methodNode.name + " " + methodNode.desc).equals(NameMapper.obfGetVertexStateSignature);
    }

    @Override
    protected boolean transform(ClassNode classNode, MethodNode methodNode) {
        for (String name : this.methodsToReplace) {
            if (!NameMapper.getInstance().isMethod(methodNode, this.className, name)) continue;
            return this.redefineMethod(classNode, methodNode, name);
        }
        if ((methodNode.name + " " + methodNode.desc).equals(NameMapper.drawSignature)) {
            return this.transformDraw(methodNode);
        }
        if ((methodNode.name + " " + methodNode.desc).equals(NameMapper.obfDrawSignature)) {
            return this.transformSrgDraw(methodNode);
        }
        if ((methodNode.name + " " + methodNode.desc).equals(NameMapper.getVertexStateSignature)) {
            return this.transformGetVertexState(methodNode);
        }
        if ((methodNode.name + " " + methodNode.desc).equals(NameMapper.obfGetVertexStateSignature)) {
            return this.transformSrgGetVertexState(methodNode);
        }
        return false;
    }

    protected boolean transformDraw(MethodNode methodNode) {
        boolean fixedFive = false;
        boolean replacedShift = false;
        boolean hasFoundBrightness = false;
        boolean findInstanceOfTwo = false;
        boolean addedTexture2 = false;
        boolean hasFoundBrightnessAgain = false;
        boolean addedDisable2 = false;
        int replace32 = 0;
        int replace8 = 0;
        int newStride = 40;
        int newInts = 10;
        ListIterator it = methodNode.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (!fixedFive && insn.getOpcode() == 8) {
                FMLLog.info((String)"Replaced a 5 with 40", (Object[])new Object[0]);
                it.set(new IntInsnNode(16, 40));
                fixedFive = true;
            }
            if (!replacedShift && fixedFive && insn.getOpcode() == 122) {
                FMLLog.info((String)"Dividing instead of shifting", (Object[])new Object[0]);
                it.set(new InsnNode(108));
                replacedShift = true;
            }
            if (!hasFoundBrightness && replacedShift && fixedFive && insn.getOpcode() == 180 && insn instanceof FieldInsnNode && (((FieldInsnNode)insn).name.equals(this.obfBrightness) || ((FieldInsnNode)insn).name.equals(this.unObfBrightness))) {
                hasFoundBrightness = true;
                it.next();
            }
            if (hasFoundBrightness && insn.getOpcode() == 5) {
                FMLLog.info((String)"Found that 2", (Object[])new Object[0]);
                it.set(new InsnNode(6));
                findInstanceOfTwo = true;
            }
            if (!addedTexture2 && hasFoundBrightness && insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("glTexCoordPointer")) {
                it.add(new LdcInsnNode((Object)new Integer(32888)));
                it.add(new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glEnableClientState", "(I)V"));
                it.add(new LdcInsnNode((Object)33986));
                it.add(new MethodInsnNode(184, "net/minecraft/client/renderer/OpenGlHelper", "setClientActiveTexture", "(I)V"));
                it.add(new VarInsnNode(25, 0));
                it.add(new InsnNode(87));
                it.add(new FieldInsnNode(178, "net/minecraft/client/renderer/Tessellator", "shortBuffer", "Ljava/nio/ShortBuffer;"));
                it.add(new IntInsnNode(16, 16));
                it.add(new MethodInsnNode(182, "java/nio/ShortBuffer", "position", "(I)Ljava/nio/Buffer;"));
                it.add(new InsnNode(87));
                it.add(new InsnNode(6));
                it.add(new IntInsnNode(16, newStride));
                it.add(new VarInsnNode(25, 0));
                it.add(new InsnNode(87));
                it.add(new FieldInsnNode(178, "net/minecraft/client/renderer/Tessellator", "shortBuffer", "Ljava/nio/ShortBuffer;"));
                it.add(new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glTexCoordPointer", "(IILjava/nio/ShortBuffer;)V"));
                addedTexture2 = true;
            }
            if (!hasFoundBrightnessAgain && addedTexture2 && insn.getOpcode() == 180 && insn instanceof FieldInsnNode && (((FieldInsnNode)insn).name.equals(this.obfBrightness) || ((FieldInsnNode)insn).name.equals(this.unObfBrightness))) {
                hasFoundBrightnessAgain = true;
            }
            if (!addedDisable2 && hasFoundBrightnessAgain && insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("glDisableClientState")) {
                it.add(new LdcInsnNode((Object)33986));
                it.add(new MethodInsnNode(184, "net/minecraft/client/renderer/OpenGlHelper", "setClientActiveTexture", "(I)V"));
                it.add(new LdcInsnNode((Object)32888));
                it.add(new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glDisableClientState", "(I)V"));
                addedDisable2 = true;
            }
            if (insn.getOpcode() != 16) continue;
            if (((IntInsnNode)insn).operand == 32) {
                ((IntInsnNode)insn).operand = newStride;
                ++replace32;
            }
            if (((IntInsnNode)insn).operand != 8) continue;
            ((IntInsnNode)insn).operand = newInts;
            ++replace8;
        }
        if (!hasFoundBrightness) {
            FMLLog.severe((String)("Could not find " + this.unObfBrightness + " or " + this.obfBrightness + " while transforming Tessellator.draw!"), (Object[])new Object[0]);
        } else if (!findInstanceOfTwo) {
            FMLLog.severe((String)"Reached the end of the list without finding a 2 to replace while transforming Tessellator.draw!", (Object[])new Object[0]);
        }
        FMLLog.info((String)("Replaced " + replace32 + " instances of 32 with " + newStride + "."), (Object[])new Object[0]);
        FMLLog.info((String)("Replaced " + replace8 + " instances of 8 with " + newInts + "."), (Object[])new Object[0]);
        return fixedFive && replacedShift && hasFoundBrightness && findInstanceOfTwo && addedTexture2 && addedDisable2;
    }

    boolean transformGetVertexState(MethodNode methodNode) {
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (insn.getOpcode() != 16 || ((IntInsnNode)insn).operand != 32) continue;
            ((IntInsnNode)insn).operand = 40;
            return true;
        }
        FMLLog.severe((String)"Could not find a 32 to transform to a 40", (Object[])new Object[0]);
        return false;
    }

    protected boolean transformSrgDraw(MethodNode methodNode) {
        boolean fixedFive = false;
        boolean replacedShift = false;
        boolean hasFoundBrightness = false;
        boolean findInstanceOfTwo = false;
        boolean addedTexture2 = false;
        boolean hasFoundBrightnessAgain = false;
        boolean addedDisable2 = false;
        int replace32 = 0;
        int replace8 = 0;
        int newStride = 40;
        int newInts = 10;
        ListIterator it = methodNode.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (!fixedFive && insn.getOpcode() == 8) {
                FMLLog.info((String)"Replaced a 5 with 40", (Object[])new Object[0]);
                it.set(new IntInsnNode(16, 40));
                fixedFive = true;
            }
            if (!replacedShift && fixedFive && insn.getOpcode() == 122) {
                FMLLog.info((String)"Dividing instead of shifting", (Object[])new Object[0]);
                it.set(new InsnNode(108));
                replacedShift = true;
            }
            if (!hasFoundBrightness && replacedShift && fixedFive && insn.getOpcode() == 180 && insn instanceof FieldInsnNode && (((FieldInsnNode)insn).name.equals(this.obfBrightness) || ((FieldInsnNode)insn).name.equals(this.unObfBrightness))) {
                hasFoundBrightness = true;
                it.next();
            }
            if (hasFoundBrightness && insn.getOpcode() == 5) {
                FMLLog.info((String)"Found that 2", (Object[])new Object[0]);
                it.set(new InsnNode(6));
                findInstanceOfTwo = true;
            }
            if (!addedTexture2 && hasFoundBrightness && insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("glTexCoordPointer")) {
                it.add(new LdcInsnNode((Object)new Integer(32888)));
                it.add(new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glEnableClientState", "(I)V"));
                it.add(new LdcInsnNode((Object)33986));
                it.add(new MethodInsnNode(184, "net/minecraft/client/renderer/OpenGlHelper", "func_77472_b", "(I)V"));
                it.add(new VarInsnNode(25, 0));
                it.add(new InsnNode(87));
                it.add(new FieldInsnNode(178, "net/minecraft/client/renderer/Tessellator", "field_147567_e", "Ljava/nio/ShortBuffer;"));
                it.add(new IntInsnNode(16, 16));
                it.add(new MethodInsnNode(182, "java/nio/ShortBuffer", "position", "(I)Ljava/nio/Buffer;"));
                it.add(new InsnNode(87));
                it.add(new InsnNode(6));
                it.add(new IntInsnNode(16, newStride));
                it.add(new VarInsnNode(25, 0));
                it.add(new InsnNode(87));
                it.add(new FieldInsnNode(178, "net/minecraft/client/renderer/Tessellator", "field_147567_e", "Ljava/nio/ShortBuffer;"));
                it.add(new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glTexCoordPointer", "(IILjava/nio/ShortBuffer;)V"));
                addedTexture2 = true;
            }
            if (!hasFoundBrightnessAgain && addedTexture2 && insn.getOpcode() == 180 && insn instanceof FieldInsnNode && (((FieldInsnNode)insn).name.equals(this.obfBrightness) || ((FieldInsnNode)insn).name.equals(this.unObfBrightness))) {
                hasFoundBrightnessAgain = true;
            }
            if (!addedDisable2 && hasFoundBrightnessAgain && insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("glDisableClientState")) {
                it.add(new LdcInsnNode((Object)33986));
                it.add(new MethodInsnNode(184, "net/minecraft/client/renderer/OpenGlHelper", "func_77472_b", "(I)V"));
                it.add(new LdcInsnNode((Object)32888));
                it.add(new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glDisableClientState", "(I)V"));
                addedDisable2 = true;
            }
            if (insn.getOpcode() != 16) continue;
            if (((IntInsnNode)insn).operand == 32) {
                ((IntInsnNode)insn).operand = newStride;
                ++replace32;
            }
            if (((IntInsnNode)insn).operand != 8) continue;
            ((IntInsnNode)insn).operand = newInts;
            ++replace8;
        }
        if (!hasFoundBrightness) {
            FMLLog.severe((String)("Could not find " + this.unObfBrightness + " or " + this.obfBrightness + " while transforming Tessellator.draw!"), (Object[])new Object[0]);
        } else if (!findInstanceOfTwo) {
            FMLLog.severe((String)"Reached the end of the list without finding a 2 to replace while transforming Tessellator.draw!", (Object[])new Object[0]);
        }
        FMLLog.info((String)("Replaced " + replace32 + " instances of 32 with " + newStride + "."), (Object[])new Object[0]);
        FMLLog.info((String)("Replaced " + replace8 + " instances of 8 with " + newInts + "."), (Object[])new Object[0]);
        return fixedFive && replacedShift && hasFoundBrightness && findInstanceOfTwo && addedTexture2 && addedDisable2;
    }

    boolean transformSrgGetVertexState(MethodNode methodNode) {
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (insn.getOpcode() != 16 || ((IntInsnNode)insn).operand != 32) continue;
            ((IntInsnNode)insn).operand = 40;
            return true;
        }
        FMLLog.severe((String)"Could not find a 32 to transform to a 40", (Object[])new Object[0]);
        return false;
    }
}

