/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer.core;

import coloredlightscore.src.asm.ColoredLightsCoreDummyContainer;
import coloredlightscore.src.asm.ColoredLightsCoreLoadingPlugin;
import coloredlightscore.src.asm.transformer.core.JavaUtils;
import coloredlightscore.src.asm.transformer.core.NameMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.launchwrapper.IClassNameTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ASMUtils {
    private static IClassNameTransformer nameTransformer;
    private static boolean nameTransChecked;

    private ASMUtils() {
    }

    public static final String deobfuscate(String className, FieldNode field) {
        return ASMUtils.deobfuscateField(className, field.name, field.desc);
    }

    public static final String deobfuscateField(String className, String fieldName, String desc) {
        return FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(className, fieldName, desc);
    }

    public static final String deobfuscate(String className, MethodNode method) {
        return ASMUtils.deobfuscateMethod(className, method.name, method.desc);
    }

    public static final String deobfuscateMethod(String className, String methodName, String desc) {
        return FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(className, methodName, desc);
    }

    public static final String getFieldDescriptor(ClassNode clazz, String fieldName) {
        for (FieldNode field : clazz.fields) {
            if (!field.name.equals(fieldName)) continue;
            return field.desc;
        }
        return null;
    }

    public static final boolean useMcpNames() {
        return ColoredLightsCoreLoadingPlugin.MCP_ENVIRONMENT;
    }

    public static final AbstractInsnNode findLastReturn(MethodNode method) {
        int searchFor = Type.getReturnType((String)method.desc).getOpcode(172);
        return ASMUtils.findLastOpcode(method, searchFor);
    }

    public static final AbstractInsnNode findLastOpcode(MethodNode method, int opcode) {
        AbstractInsnNode found = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode insn = method.instructions.get(i);
            if (insn.getOpcode() != opcode) continue;
            found = insn;
        }
        return found;
    }

    public static final LdcInsnNode findLastLDC(MethodNode method, String ldcArgument) {
        LdcInsnNode found = null;
        LdcInsnNode candidate = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode insn = method.instructions.get(i);
            if (insn.getOpcode() != 18) continue;
            candidate = (LdcInsnNode)insn;
            if (!ldcArgument.equals(candidate.cst)) continue;
            found = candidate;
        }
        return found;
    }

    public static final MethodInsnNode findLastInvoke(MethodNode method, int opcode, String className, String methodNameAndDescriptor, boolean dumpCandidates) {
        MethodInsnNode found = null;
        MethodInsnNode candidate = null;
        String obfClass = NameMapper.getInstance().getClassName(className);
        String obfName = NameMapper.getInstance().getMethodName(className, methodNameAndDescriptor);
        String obfDesc = NameMapper.getInstance().getMethodDescriptor(className, methodNameAndDescriptor);
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode insn = method.instructions.get(i);
            if (insn.getOpcode() != opcode) continue;
            candidate = (MethodInsnNode)insn;
            if (dumpCandidates) {
                ColoredLightsCoreDummyContainer.CLLog.debug(String.format("   findLastInvoke@%s is %s/%s %s, looking for [%s|%s]/%s %s", i, candidate.owner, candidate.name, candidate.desc, className, obfClass, obfName, obfDesc));
            }
            if (!(candidate.owner.equals(obfClass) | candidate.owner.equals(className)) || !candidate.name.equals(obfName) || !candidate.desc.equals(obfDesc)) continue;
            found = candidate;
        }
        return found;
    }

    public static final String makeNameInternal(String name) {
        return name.replace('.', '/');
    }

    public static final String undoInternalName(String name) {
        return name.replace('/', '.');
    }

    public static final MethodInsnNode generateMethodCall(Method method) {
        int opcode = Modifier.isStatic(method.getModifiers()) ? 184 : 182;
        return new MethodInsnNode(opcode, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method));
    }

    public static final MethodNode generateSetterMethod(String targetClass, String setterMethodName, String fieldName, String fieldTypeDescriptor) {
        return ASMUtils.generateSetterMethod(targetClass, setterMethodName, fieldName, fieldTypeDescriptor, 1);
    }

    public static final MethodNode generateSetterMethod(String targetClass, String setterMethodName, String fieldName, String fieldTypeDescriptor, int methodAccess) {
        Type fieldType = Type.getType((String)fieldTypeDescriptor);
        MethodNode setter = new MethodNode();
        setter.name = setterMethodName;
        setter.desc = String.format("(%s)V", fieldTypeDescriptor);
        setter.exceptions = new ArrayList();
        setter.access = methodAccess;
        setter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        setter.instructions.add((AbstractInsnNode)new VarInsnNode(fieldType.getOpcode(21), 1));
        setter.instructions.add((AbstractInsnNode)new FieldInsnNode(181, targetClass, fieldName, fieldTypeDescriptor));
        setter.instructions.add((AbstractInsnNode)new InsnNode(177));
        return setter;
    }

    public static final MethodNode generateGetterMethod(String targetClass, String setterMethodName, String fieldName, String fieldTypeDescriptor) {
        return ASMUtils.generateGetterMethod(targetClass, setterMethodName, fieldName, fieldTypeDescriptor, 1);
    }

    public static final MethodNode generateGetterMethod(String targetClass, String setterMethodName, String fieldName, String fieldTypeDescriptor, int methodAccess) {
        Type fieldType = Type.getType((String)fieldTypeDescriptor);
        MethodNode getter = new MethodNode();
        getter.name = setterMethodName;
        getter.desc = String.format("()%s", fieldTypeDescriptor);
        getter.exceptions = new ArrayList();
        getter.access = methodAccess;
        getter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        getter.instructions.add((AbstractInsnNode)new FieldInsnNode(180, targetClass, fieldName, fieldTypeDescriptor));
        getter.instructions.add((AbstractInsnNode)new InsnNode(fieldType.getOpcode(172)));
        return getter;
    }

    public static ClassNode getClassNode(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode clazz = new ClassNode();
        reader.accept((ClassVisitor)clazz, 0);
        return clazz;
    }

    public static IClassNameTransformer getClassNameTransformer() {
        if (!nameTransChecked) {
            Iterable nameTransformers = Iterables.filter((Iterable)ColoredLightsCoreLoadingPlugin.CLASSLOADER.getTransformers(), IClassNameTransformer.class);
            nameTransformer = (IClassNameTransformer)Iterables.getOnlyElement((Iterable)nameTransformers, null);
        }
        return nameTransformer;
    }

    public static String deobfuscateClass(String obfName) {
        IClassNameTransformer t = ASMUtils.getClassNameTransformer();
        return ASMUtils.makeNameInternal(t == null ? obfName : t.remapClassName(obfName));
    }

    public static String obfuscateClass(String deobfName) {
        IClassNameTransformer t = ASMUtils.getClassNameTransformer();
        return ASMUtils.makeNameInternal(t == null ? deobfName : t.unmapClassName(deobfName));
    }

    public static ClassNode getClassNode(String name) {
        try {
            return ASMUtils.getClassNode(ColoredLightsCoreLoadingPlugin.CLASSLOADER.getClassBytes(ASMUtils.obfuscateClass(name)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AnnotationNode getAnnotation(FieldNode field, Class<? extends Annotation> ann) {
        return ASMUtils.getAnnotation(JavaUtils.concatNullable(field.visibleAnnotations, field.invisibleAnnotations), ann);
    }

    public static AnnotationNode getAnnotation(ClassNode clazz, Class<? extends Annotation> ann) {
        return ASMUtils.getAnnotation(JavaUtils.concatNullable(clazz.visibleAnnotations, clazz.invisibleAnnotations), ann);
    }

    public static AnnotationNode getAnnotation(MethodNode method, Class<? extends Annotation> ann) {
        return ASMUtils.getAnnotation(JavaUtils.concatNullable(method.visibleAnnotations, method.invisibleAnnotations), ann);
    }

    public static AnnotationNode getAnnotation(Iterable<AnnotationNode> annotations, Class<? extends Annotation> ann) {
        String desc = Type.getDescriptor(ann);
        for (AnnotationNode node : annotations) {
            if (!node.desc.equals(desc)) continue;
            return node;
        }
        return null;
    }

    public static boolean hasAnnotation(FieldNode field, Class<? extends Annotation> annotation) {
        return ASMUtils.getAnnotation(field, annotation) != null;
    }

    public static boolean hasAnnotation(ClassNode clazz, Class<? extends Annotation> annotation) {
        return ASMUtils.getAnnotation(clazz, annotation) != null;
    }

    public static boolean hasAnnotation(MethodNode method, Class<? extends Annotation> annotation) {
        return ASMUtils.getAnnotation(method, annotation) != null;
    }

    public static boolean isPrimitive(Type type) {
        return type.getSort() != 9 && type.getSort() != 10 && type.getSort() != 11;
    }

    public static ClassInfo getClassInfo(Class<?> clazz) {
        return new ClassInfoFromClazz(clazz);
    }

    public static ClassInfo getClassInfo(ClassNode clazz) {
        return new ClassInfoFromNode(clazz);
    }

    public static ClassInfo getClassInfo(String className) {
        try {
            byte[] bytes = null;
            try {
                bytes = ColoredLightsCoreLoadingPlugin.CLASSLOADER.getClassBytes(className);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (bytes != null) {
                return new ClassInfoFromNode(ASMUtils.getClassNode(bytes));
            }
            return null;
        }
        catch (Exception e) {
            throw JavaUtils.throwUnchecked(e);
        }
    }

    public static boolean isAssignableFrom(ClassInfo parent, ClassInfo child) {
        if (parent.internalName().equals(child.internalName()) || parent.internalName().equals(child.superName()) || child.interfaces().contains(parent.internalName())) {
            return true;
        }
        if (child.superName() != null && !child.superName().equals("java/lang/Object")) {
            return ASMUtils.isAssignableFrom(parent, ASMUtils.getClassInfo(child.superName()));
        }
        return false;
    }

    public static String getTypeKeyword(Type type) {
        if (type == Type.BOOLEAN_TYPE) {
            return "boolean";
        }
        if (type == Type.BYTE_TYPE) {
            return "byte";
        }
        if (type == Type.CHAR_TYPE) {
            return "char";
        }
        if (type == Type.DOUBLE_TYPE) {
            return "double";
        }
        if (type == Type.FLOAT_TYPE) {
            return "float";
        }
        if (type == Type.INT_TYPE) {
            return "int";
        }
        if (type == Type.LONG_TYPE) {
            return "long";
        }
        if (type == Type.SHORT_TYPE) {
            return "short";
        }
        if (type == Type.VOID_TYPE) {
            return "void";
        }
        String internalName = type.getInternalName();
        int lastSlash = internalName.lastIndexOf(47);
        if (lastSlash > -1) {
            return internalName.substring(lastSlash + 1);
        }
        return internalName;
    }

    public static void assertClassContainsHelperMethod(String className, String methodName, String methodDescriptor) throws IOException, IllegalArgumentException {
        String classPath = "/" + ASMUtils.makeNameInternal(className) + ".class";
        ClassReader classReader = new ClassReader(ASMUtils.class.getResourceAsStream(classPath));
        ClassNode classNode = new ClassNode();
        boolean foundStatic = false;
        boolean foundNonstatic = false;
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals(methodDescriptor)) continue;
            if ((m.access & 8) == 8) {
                foundStatic = true;
                continue;
            }
            foundNonstatic = true;
        }
        if (!foundStatic) {
            Type expectedReturnType = Type.getReturnType((String)methodDescriptor);
            Type[] expectedArgs = Type.getArgumentTypes((String)methodDescriptor);
            String plainTextDescriptor = String.format("%s %s(", ASMUtils.getTypeKeyword(expectedReturnType), methodName);
            for (int argNum = 0; argNum < expectedArgs.length; ++argNum) {
                if (argNum > 0 && argNum <= expectedArgs.length - 1) {
                    plainTextDescriptor = plainTextDescriptor + ", ";
                }
                plainTextDescriptor = plainTextDescriptor + ASMUtils.getTypeKeyword(expectedArgs[argNum]);
            }
            String exceptionMessage = foundNonstatic ? String.format("Missing STATIC modifier on helper method %s.%s %s!", className, methodName, methodDescriptor) : String.format("Unable to locate helper method \"static %s)\" in class %s!", plainTextDescriptor, className);
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    static {
        nameTransChecked = false;
    }

    private static enum ClassToNameFunc implements Function<Class<?>, String>
    {
        INSTANCE;


        public String apply(Class<?> input) {
            return ASMUtils.makeNameInternal(input.getCanonicalName());
        }
    }

    private static final class ClassInfoFromNode
    implements ClassInfo {
        private final ClassNode clazz;

        ClassInfoFromNode(ClassNode clazz) {
            this.clazz = clazz;
        }

        @Override
        public Collection<String> interfaces() {
            return this.clazz.interfaces;
        }

        @Override
        public String superName() {
            return this.clazz.superName;
        }

        @Override
        public String internalName() {
            return this.clazz.name;
        }

        @Override
        public boolean isInterface() {
            return (this.clazz.access & 0x200) == 512;
        }
    }

    private static final class ClassInfoFromClazz
    implements ClassInfo {
        private final Class<?> clazz;
        private final Collection<String> interfaces;

        ClassInfoFromClazz(Class<?> clazz) {
            this.clazz = clazz;
            this.interfaces = Collections2.transform(Arrays.asList(clazz.getInterfaces()), (Function)ClassToNameFunc.INSTANCE);
        }

        @Override
        public Collection<String> interfaces() {
            return this.interfaces;
        }

        @Override
        public String superName() {
            Class<?> s = this.clazz.getSuperclass();
            return s == null ? null : ASMUtils.makeNameInternal(s.getCanonicalName());
        }

        @Override
        public String internalName() {
            return ASMUtils.makeNameInternal(this.clazz.getCanonicalName());
        }

        @Override
        public boolean isInterface() {
            return this.clazz.isInterface();
        }
    }

    public static interface ClassInfo {
        public Collection<String> interfaces();

        public String superName();

        public String internalName();

        public boolean isInterface();
    }
}

