/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer.core;

import coloredlightscore.src.asm.transformer.core.ASMUtils;
import coloredlightscore.src.asm.transformer.core.MethodTransformer;
import coloredlightscore.src.asm.transformer.core.NameMapper;
import java.io.IOException;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class HelperMethodTransformer
extends MethodTransformer {
    protected String className;
    protected String classNameDeobfuscated;
    public boolean checkForHelperFunction = true;

    public HelperMethodTransformer(String className) {
        this.className = className;
        this.classNameDeobfuscated = NameMapper.getInstance().getClassName(className).replace('/', '.');
        this.checkForHelperFunction = !NameMapper.getInstance().isObfuscated();
    }

    protected abstract Class<?> getHelperClass();

    @Override
    protected boolean transforms(String className) {
        return className.equals(this.classNameDeobfuscated) || className.equals(this.className);
    }

    protected final boolean redefineMethod(ClassNode clazz, MethodNode targetMethod, String helperMethod) {
        Type targetMethodReturnType = Type.getReturnType((String)targetMethod.desc);
        InsnList staticInvoke = this.generateHelperInvoke(clazz, targetMethod, helperMethod, false);
        int returnOpcode = targetMethodReturnType.getOpcode(172);
        staticInvoke.add((AbstractInsnNode)new InsnNode(returnOpcode));
        targetMethod.localVariables.clear();
        targetMethod.instructions.clear();
        targetMethod.instructions.add(staticInvoke);
        return true;
    }

    protected final boolean addReturnMethod(ClassNode clazz, MethodNode targetMethod, String helperMethod) {
        InsnList staticInvoke = this.generateHelperInvoke(clazz, targetMethod, helperMethod, true);
        targetMethod.instructions.insertBefore(ASMUtils.findLastReturn(targetMethod), staticInvoke);
        return true;
    }

    protected InsnList generateHelperInvoke(ClassNode targetClass, MethodNode targetMethod, String helperMethod, boolean includeReturnVarAsParam) {
        InsnList staticInvoke = new InsnList();
        Type targetClassType = Type.getType((String)targetClass.name);
        Type helperClassType = Type.getType(this.getHelperClass());
        Type[] args = Type.getArgumentTypes((String)targetMethod.desc);
        if (helperMethod.indexOf(32) > -1) {
            helperMethod = helperMethod.substring(0, helperMethod.indexOf(32));
        }
        String helperMethodDescriptor = includeReturnVarAsParam ? String.format("(L%s;L%s;%s", Type.getReturnType((String)targetMethod.desc).getInternalName(), targetClassType.getInternalName(), targetMethod.desc.substring(1)) : String.format("(L%s;%s", targetClassType.getInternalName(), targetMethod.desc.substring(1));
        if (this.checkForHelperFunction) {
            try {
                ASMUtils.assertClassContainsHelperMethod(this.getHelperClass().getName(), helperMethod, helperMethodDescriptor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        staticInvoke.add((AbstractInsnNode)new VarInsnNode(25, 0));
        int index = 0;
        for (Type argument : args) {
            int LoadOpCode = argument.getOpcode(21);
            staticInvoke.add((AbstractInsnNode)new VarInsnNode(LoadOpCode, index + 1));
            if (LoadOpCode == 24 || LoadOpCode == 22) {
                index += 2;
                continue;
            }
            ++index;
        }
        MethodInsnNode invokestatic = new MethodInsnNode(184, helperClassType.getInternalName(), helperMethod, helperMethodDescriptor);
        staticInvoke.add((AbstractInsnNode)invokestatic);
        return staticInvoke;
    }
}

