/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer.core;

import coloredlightscore.src.asm.transformer.core.Consumer;
import coloredlightscore.src.asm.transformer.core.EnumGetterCloned;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class JavaUtils {
    private static EnumValueGetter ENUM_GETTER;
    private static Object unsafe;
    private static boolean unsafeChecked;

    private JavaUtils() {
    }

    public static <T> T safeArrayAccess(T[] array, int index) {
        return JavaUtils.arrayIndexExists(array, index) ? (T)array[index] : null;
    }

    public static boolean arrayIndexExists(Object[] array, int index) {
        return index >= 0 && index < array.length;
    }

    public static <T> T defaultedArrayAccess(T[] array, int index, T defaultValue) {
        return JavaUtils.arrayIndexExists(array, index) ? array[index] : defaultValue;
    }

    public static boolean listIndexExists(List<?> list, int index) {
        return index >= 0 && index < list.size();
    }

    public static <T> T safeListAccess(List<T> list, int index) {
        return JavaUtils.listIndexExists(list, index) ? (T)list.get(index) : null;
    }

    public static <T> Iterator<T> nCallsIterator(final Supplier<T> supplier, final int n) {
        return new AbstractIterator<T>(){
            private int counter = 0;

            protected T computeNext() {
                return ++this.counter <= n ? supplier.get() : this.endOfData();
            }
        };
    }

    public static <T> Iterable<T> nCalls(final Supplier<T> supplier, final int n) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return JavaUtils.nCallsIterator(supplier, n);
            }
        };
    }

    public static <T> List<T> nullToEmpty(List<T> nullable) {
        return nullable == null ? Collections.emptyList() : nullable;
    }

    public static <T> Iterable<T> concatNullable(Iterable<T> a, Iterable<T> b) {
        return a == null ? (b == null ? Collections.emptyList() : b) : (b == null ? a : Iterables.concat(a, b));
    }

    public static <T> void foreach(Iterable<T> it, Consumer<T> c) {
        JavaUtils.foreach(it.iterator(), c);
    }

    public static <T> void foreach(Iterator<T> it, Consumer<T> c) {
        while (it.hasNext()) {
            c.apply(it.next());
        }
    }

    public static <T> void foreach(T[] arr, Consumer<T> c) {
        for (T t : arr) {
            c.apply(t);
        }
    }

    public static <T, R> R[] transform(T[] in, R[] out, Function<T, R> func) {
        int l = in.length;
        Preconditions.checkArgument((l == out.length ? 1 : 0) != 0);
        for (int i = 0; i < l; ++i) {
            out[i] = func.apply(in[i]);
        }
        return out;
    }

    public static RuntimeException throwUnchecked(Throwable t) {
        JavaUtils.throwUnchecked0(t);
        throw new AssertionError((Object)"unreachable");
    }

    private static <T extends Throwable> void throwUnchecked0(Throwable t) throws T {
        throw t;
    }

    public static long encodeInts(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    public static int decodeIntA(long l) {
        return (int)(l >> 32);
    }

    public static int decodeIntB(long l) {
        return (int)l;
    }

    public static <T extends Enum<T>> T[] getEnumValues(Class<T> clazz) {
        return ENUM_GETTER.getEnumValues(clazz);
    }

    public static <T extends Enum<T>> T byOrdinal(Class<T> clazz, int ordinal) {
        return (T)JavaUtils.safeArrayAccess(JavaUtils.getEnumValues(clazz), ordinal);
    }

    private static void initUnsafe() {
        if (unsafeChecked) {
            return;
        }
        try {
            Field field = Class.forName("sun.misc.Unsafe").getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = field.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasUnsafe() {
        JavaUtils.initUnsafe();
        return unsafe != null;
    }

    public static Object getUnsafe() {
        JavaUtils.initUnsafe();
        return unsafe;
    }

    static {
        try {
            Class.forName("sun.misc.SharedSecrets");
            ENUM_GETTER = Class.forName("de.take_weiland.mods.commons.util.EnumGetterShared").asSubclass(EnumValueGetter.class).newInstance();
        }
        catch (Exception e) {
            FMLLog.info((String)"sun.misc.SharedSecrets not found. Falling back to default EnumGetter", (Object[])new Object[0]);
            ENUM_GETTER = new EnumGetterCloned();
        }
    }

    static interface EnumValueGetter {
        public <T extends Enum<T>> T[] getEnumValues(Class<T> var1);
    }
}

