/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer.core;

import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class NameMapper {
    private HashMap<String, SeargeData> m_NameList = new HashMap();
    private static NameMapper INSTANCE = null;
    private boolean MCP_ENVIRONMENT = false;
    public static String drawSignature = "draw ()I";
    public static String obfDrawSignature = "func_78381_a ()I";
    public static String getVertexStateSignature = "getVertexState (FFF)Lnet/minecraft/client/shader/TesselatorVertexState;";
    public static String obfGetVertexStateSignature = "func_147564_a (FFF)Lnet/minecraft/client/shader/TesselatorVertexState;";

    public static NameMapper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NameMapper();
        }
        return INSTANCE;
    }

    public NameMapper() {
        this.registerSrgName("CL: net/minecraft/block/Block net/minecraft/block/Block");
        this.registerSrgName("MD: net/minecraft/block/Block/setLightLevel (F)Lnet/minecraft/block/Block; net/minecraft/block/Block/func_149715_a (F)Lnet/minecraft/block/Block;");
        this.registerSrgName("CL: net/minecraft/world/ChunkCache net/minecraft/world/ChunkCache");
        this.registerSrgName("MD: net/minecraft/world/ChunkCache/getLightBrightnessForSkyBlocks (IIII)I net/minecraft/world/ChunkCache/func_72802_i (IIII)I");
        this.registerSrgName("CL: net/minecraft/entity/player/EntityPlayerMP net/minecraft/entity/player/EntityPlayerMP");
        this.registerSrgName("MD: net/minecraft/entity/player/EntityPlayerMP/onUpdate ()V net/minecraft/entity/player/EntityPlayerMP/func_70071_h_ ()V");
        this.registerSrgName("CL: net/minecraft/client/renderer/EntityRenderer net/minecraft/client/renderer/EntityRenderer");
        this.registerSrgName("MD: net/minecraft/client/renderer/EntityRenderer/updateLightmap (F)V net/minecraft/client/renderer/EntityRenderer/func_78472_g (F)V");
        this.registerSrgName("MD: net/minecraft/client/renderer/EntityRenderer/disableLightmap (D)V net/minecraft/client/renderer/EntityRenderer/func_78483_a (D)V");
        this.registerSrgName("MD: net/minecraft/client/renderer/EntityRenderer/enableLightmap (D)V net/minecraft/client/renderer/EntityRenderer/func_78463_b (D)V");
        this.registerSrgName("CL: net/minecraft/world/chunk/storage/ExtendedBlockStorage net/minecraft/world/chunk/storage/ExtendedBlockStorage");
        this.registerSrgName("MD: net/minecraft/world/chunk/storage/ExtendedBlockStorage/setExtBlocklightValue (IIII)V net/minecraft/world/chunk/storage/ExtendedBlockStorage/func_76677_d (IIII)V");
        this.registerSrgName("MD: net/minecraft/world/chunk/storage/ExtendedBlockStorage/getExtBlocklightValue (III)I net/minecraft/world/chunk/storage/ExtendedBlockStorage/func_76674_d (III)I");
        this.registerSrgName("FD: net/minecraft/world/chunk/storage/ExtendedBlockStorage/blockLSBArray net/minecraft/world/chunk/storage/ExtendedBlockStorage/field_76680_d");
        this.registerSrgName("CL: net/minecraft/server/management/PlayerManager$PlayerInstance net/minecraft/server/management/PlayerManager$PlayerInstance");
        this.registerSrgName("MD: net/minecraft/server/management/PlayerManager$PlayerInstance/sendToAllPlayersWatchingChunk (Lnet/minecraft/network/Packet;)V net/minecraft/server/management/PlayerManager$PlayerInstance/func_151251_a (Lnet/minecraft/network/Packet;)V");
        this.registerSrgName("FD: net/minecraft/server/management/PlayerManager$PlayerInstance/chunkLocation net/minecraft/server/management/PlayerManager$PlayerInstance/field_73264_c");
        this.registerSrgName("CL: net/minecraft/client/renderer/RenderBlocks net/minecraft/client/renderer/RenderBlocks");
        this.registerSrgName("MD: net/minecraft/client/renderer/RenderBlocks/renderStandardBlockWithAmbientOcclusion (Lnet/minecraft/block/Block;IIIFFF)Z net/minecraft/client/renderer/RenderBlocks/func_147751_a (Lnet/minecraft/block/Block;IIIFFF)Z");
        this.registerSrgName("MD: net/minecraft/client/renderer/RenderBlocks/renderStandardBlockWithColorMultiplier (Lnet/minecraft/block/Block;IIIFFF)Z net/minecraft/client/renderer/RenderBlocks/func_147736_d (Lnet/minecraft/block/Block;IIIFFF)Z");
        this.registerSrgName("CL: net/minecraft/client/renderer/Tessellator net/minecraft/client/renderer/Tessellator");
        this.registerSrgName("MD: net/minecraft/client/renderer/Tessellator/setBrightness (I)V net/minecraft/client/renderer/Tessellator/func_78380_c (I)V");
        this.registerSrgName("MD: net/minecraft/client/renderer/Tessellator/addVertex (DDD)V net/minecraft/client/renderer/Tessellator/func_78377_a (DDD)V");
        this.registerSrgName("CL: net/minecraft/world/World net/minecraft/world/World");
        this.registerSrgName("MD: net/minecraft/world/World/getBlockLightValue_do (IIIZ)I net/minecraft/world/World/func_72849_a (IIIZ)I");
        this.registerSrgName("MD: net/minecraft/world/World/getLightBrightnessForSkyBlocks (IIII)I net/minecraft/world/World/func_72802_i (IIII)I");
        this.registerSrgName("MD: net/minecraft/world/World/getLightBrightness (III)F net/minecraft/world/World/func_72801_o (III)F");
        this.registerSrgName("MD: net/minecraft/world/World/computeLightValue (IIILnet/minecraft/world/EnumSkyBlock;)I net/minecraft/world/World/func_98179_a (IIILnet/minecraft/world/EnumSkyBlock;)I");
        this.registerSrgName("MD: net/minecraft/world/World/updateLightByType (Lnet/minecraft/world/EnumSkyBlock;III)Z net/minecraft/world/World/func_147463_c (Lnet/minecraft/world/EnumSkyBlock;III)Z");
        this.registerSrgName("CL: net/minecraft/network/NetHandlerPlayServer net/minecraft/network/NetHandlerPlayServer");
        this.registerSrgName("MD: net/minecraft/network/NetHandlerPlayServer/sendPacket (Lnet/minecraft/network/Packet;)V net/minecraft/network/NetHandlerPlayServer/func_147359_a (Lnet/minecraft/network/Packet;)V");
        this.registerSrgName("CL: net/minecraft/world/chunk/NibbleArray net/minecraft/world/chunk/NibbleArray");
        this.registerSrgName("MD: net/minecraft/world/chunk/NibbleArray/get (III)I net/minecraft/world/chunk/NibbleArray/func_76582_a (III)I");
        this.registerSrgName("MD: net/minecraft/world/chunk/NibbleArray/set (IIII)V net/minecraft/world/chunk/NibbleArray/func_76581_a (IIII)V");
        this.registerSrgName("CL: net/minecraft/network/play/server/S26PacketMapChunkBulk net/minecraft/network/play/server/S26PacketMapChunkBulk");
        this.MCP_ENVIRONMENT = this.getClass().getClassLoader().getResource("net/minecraft/world/World.class") != null;
        FMLLog.info((String)"ColoredLightsCore: MCP_ENVIORNMENT=%s", (Object[])new Object[]{this.MCP_ENVIRONMENT});
    }

    public boolean isObfuscated() {
        return !this.MCP_ENVIRONMENT;
    }

    public String getClassName(String className) {
        String indexer = this.internalizeName(className);
        SeargeData srg = this.m_NameList.get(indexer);
        return srg == null ? className : (this.MCP_ENVIRONMENT ? srg.objectName : srg.objectNameObfuscated);
    }

    public String getMethodName(String ownerName, String methodName, String methodSignature) {
        String obfMethodName;
        String indexer = this.internalizeName(ownerName + "." + methodName + " " + methodSignature);
        SeargeData srg = this.m_NameList.get(indexer);
        String string = srg == null ? methodName : (obfMethodName = this.MCP_ENVIRONMENT ? srg.objectName : srg.objectNameObfuscated);
        if (obfMethodName.lastIndexOf(47) > -1) {
            return obfMethodName.substring(obfMethodName.lastIndexOf(47) + 1);
        }
        return obfMethodName;
    }

    public String getMethodName(String ownerName, String methodNameAndDescriptor) {
        String obfMethodName;
        String[] rawMaD = methodNameAndDescriptor.split("\\s+");
        String indexer = this.internalizeName(ownerName + "." + methodNameAndDescriptor);
        SeargeData srg = this.m_NameList.get(indexer);
        String string = srg == null ? rawMaD[0] : (obfMethodName = this.MCP_ENVIRONMENT ? srg.objectName : srg.objectNameObfuscated);
        if (obfMethodName.lastIndexOf(47) > -1) {
            return obfMethodName.substring(obfMethodName.lastIndexOf(47) + 1);
        }
        return obfMethodName;
    }

    public String getMethodDescriptor(String ownerName, String methodName, String methodSignature) {
        String indexer = this.internalizeName(ownerName + "." + methodName + " " + methodSignature);
        SeargeData srg = this.m_NameList.get(indexer);
        return srg == null ? methodSignature : (this.MCP_ENVIRONMENT ? srg.objectSignature : srg.objectSignatureObfuscated);
    }

    public String getMethodDescriptor(String ownerName, String methodNameAndDescriptor) {
        String[] rawMaD = methodNameAndDescriptor.split("\\s+");
        String indexer = this.internalizeName(ownerName + "." + methodNameAndDescriptor);
        SeargeData srg = this.m_NameList.get(indexer);
        return srg == null ? rawMaD[1] : (this.MCP_ENVIRONMENT ? srg.objectSignature : srg.objectSignatureObfuscated);
    }

    public boolean isMethod(MethodNode methodNode, String ownerName, String methodNameWithSignature) {
        String indexer = this.internalizeName(ownerName + "/" + methodNameWithSignature);
        SeargeData srg = this.m_NameList.get(indexer);
        String methodName = "/" + this.internalizeName(methodNode.name);
        String methodSig = this.internalizeName(methodNode.desc);
        if (srg != null) {
            if (this.MCP_ENVIRONMENT) {
                return srg.objectName.endsWith(methodName) && methodSig.equals(srg.objectSignature);
            }
            return srg.objectNameObfuscated.endsWith(methodName) && methodSig.equals(srg.objectSignatureObfuscated);
        }
        return false;
    }

    public String getJVMTypeObfuscated(String descriptor) {
        String className = "";
        String result = "";
        for (int i = 0; i < descriptor.length(); ++i) {
            if (descriptor.substring(i, i + 1).equals("L")) {
                int j = i;
                while (!descriptor.substring(j, j + 1).equals(";")) {
                    ++j;
                }
                className = descriptor.substring(i + 1, j);
                result = result + "L" + this.getClassName(className) + ";";
                i = j;
                continue;
            }
            result = result + descriptor.substring(i, i + 1);
        }
        return result;
    }

    public Type getType(String deobfuscatedTypeDescriptor) {
        String internalName = this.internalizeName(deobfuscatedTypeDescriptor);
        if (internalName.startsWith("L") && internalName.endsWith(";")) {
            internalName = internalName.substring(1, internalName.length() - 1);
        }
        return Type.getType((String)("L" + (this.MCP_ENVIRONMENT ? internalName : this.getClassName(internalName)) + ";"));
    }

    public String getClassField(String deobfuscatedClassName, String deobfuscatedFieldName) {
        String fieldName;
        String indexer = this.internalizeName(deobfuscatedClassName + "/" + deobfuscatedFieldName);
        SeargeData srg = this.m_NameList.get(indexer);
        String string = this.MCP_ENVIRONMENT ? deobfuscatedFieldName : (fieldName = srg == null ? null : srg.objectNameObfuscated);
        if (fieldName.lastIndexOf(47) > -1) {
            return fieldName.substring(fieldName.lastIndexOf(47) + 1);
        }
        return fieldName;
    }

    private void registerSrgName(String data) {
        SeargeData item = new SeargeData(data);
        this.m_NameList.put(item.uniqueName, item);
    }

    private String internalizeName(String name) {
        return name.replace('.', '/');
    }

    private class SeargeData {
        public String uniqueName;
        public String objectName;
        public String objectNameObfuscated;
        public String objectSignature;
        public String objectSignatureObfuscated;

        public SeargeData(String src) {
            String[] srcToken = src.split("\\s+");
            if (!srcToken[0].equals("PK:")) {
                if (srcToken[0].equals("CL:")) {
                    if (srcToken.length == 3) {
                        this.objectName = srcToken[1];
                        this.objectNameObfuscated = srcToken[2];
                        this.uniqueName = this.objectName;
                    }
                } else if (srcToken[0].equals("MD:")) {
                    if (srcToken.length == 5) {
                        this.objectName = srcToken[1];
                        this.objectNameObfuscated = srcToken[3];
                        this.objectSignature = srcToken[2];
                        this.objectSignatureObfuscated = srcToken[4];
                        this.uniqueName = this.objectName + " " + this.objectSignature;
                    }
                } else if (srcToken[0].equals("FD:") && srcToken.length == 3) {
                    this.objectName = srcToken[1];
                    this.objectNameObfuscated = srcToken[2];
                    this.uniqueName = this.objectName;
                }
            }
        }
    }
}

