/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.asm.transformer.core;

import coloredlightscore.src.asm.transformer.core.ASMUtils;
import coloredlightscore.src.asm.transformer.core.ExtendedClassWriter;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public abstract class SelectiveTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes != null && this.transforms(transformedName)) {
            FMLLog.info((String)"Class %s is a candidate for transforming", (Object[])new Object[]{transformedName});
            try {
                ClassNode clazz = ASMUtils.getClassNode(bytes);
                if (this.transform(clazz, transformedName)) {
                    FMLLog.info((String)("Finished Transforming class " + transformedName), (Object[])new Object[0]);
                    ExtendedClassWriter writer = new ExtendedClassWriter(3);
                    clazz.accept((ClassVisitor)writer);
                    bytes = writer.toByteArray();
                } else {
                    FMLLog.warning((String)"Did not transform %s", (Object[])new Object[]{transformedName});
                }
            }
            catch (Exception e) {
                FMLLog.severe((String)("Exception during transformation of class " + transformedName), (Object[])new Object[0]);
                e.printStackTrace();
                Throwables.propagate((Throwable)e);
            }
        }
        return bytes;
    }

    protected abstract boolean transforms(String var1);

    protected abstract boolean transform(ClassNode var1, String var2);
}

