/*
 * Decompiled with CFR 0.152.
 */
package coloredlightscore.src.helper;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class CLWorldHelper {
    public static long[] lightUpdateBlockList = new long[32768];

    public static int getBlockLightValue_do(World world, int x, int y, int z, boolean par4) {
        if (x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000) {
            if (par4 && world.func_147439_a(x, y, z).func_149710_n()) {
                int l1 = CLWorldHelper.getBlockLightValue_do(world, x, y + 1, z, false);
                int l = CLWorldHelper.getBlockLightValue_do(world, x + 1, y, z, false);
                int i1 = CLWorldHelper.getBlockLightValue_do(world, x - 1, y, z, false);
                int j1 = CLWorldHelper.getBlockLightValue_do(world, x, y, z + 1, false);
                int k1 = CLWorldHelper.getBlockLightValue_do(world, x, y, z - 1, false);
                if ((l & 0xF) > (l1 & 0xF)) {
                    l1 = l;
                }
                if ((i1 & 0xF) > (l1 & 0xF)) {
                    l1 = i1;
                }
                if ((j1 & 0xF) > (l1 & 0xF)) {
                    l1 = j1;
                }
                if ((k1 & 0xF) > (l1 & 0xF)) {
                    l1 = k1;
                }
                return l1;
            }
            if (y < 0) {
                return 0;
            }
            if (y >= 256) {
                y = 255;
            }
            Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
            return chunk.func_76629_c(x &= 0xF, y, z &= 0xF, world.field_73008_k);
        }
        return 15;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getLightBrightnessForSkyBlocks(World world, int x, int y, int z, int lightValue) {
        int skyBrightness = world.func_72925_a(EnumSkyBlock.Sky, x, y, z);
        int blockBrightness = world.func_72925_a(EnumSkyBlock.Block, x, y, z);
        if ((blockBrightness = blockBrightness & 0xF | (blockBrightness & 0x1E0) >> 1 | (blockBrightness & 0x3C00) >> 2 | (blockBrightness & 0x78000) >> 3) < (lightValue = lightValue & 0xF | (lightValue & 0x1E0) >> 1 | (lightValue & 0x3C00) >> 2 | (lightValue & 0x78000) >> 3)) {
            blockBrightness = lightValue;
        }
        return skyBrightness << 20 | blockBrightness << 4;
    }

    public static float getLightBrightness(World world, int par1, int par2, int par3) {
        return world.field_73011_w.field_76573_f[world.func_72957_l(par1, par2, par3) & 0xF];
    }

    public static int computeLightValue(World world, int x, int y, int z, EnumSkyBlock par4EnumSkyBlock) {
        int opacity;
        if (par4EnumSkyBlock == EnumSkyBlock.Sky && world.func_72937_j(x, y, z)) {
            return 15;
        }
        Block block = world.func_147439_a(x, y, z);
        int blockLight = block == null ? 0 : block.getLightValue((IBlockAccess)world, x, y, z);
        int currentLight = par4EnumSkyBlock == EnumSkyBlock.Sky ? 0 : blockLight;
        int n = opacity = block == null ? 0 : block.getLightOpacity((IBlockAccess)world, x, y, z);
        if (opacity >= 15 && blockLight > 0) {
            opacity = 1;
        }
        if (opacity < 1) {
            opacity = 1;
        }
        if (opacity >= 15) {
            return 0;
        }
        for (int faceIndex = 0; faceIndex < 6; ++faceIndex) {
            int l1 = x + Facing.field_71586_b[faceIndex];
            int i2 = y + Facing.field_71587_c[faceIndex];
            int j2 = z + Facing.field_71585_d[faceIndex];
            int neighboorLight = world.func_72972_b(par4EnumSkyBlock, l1, i2, j2);
            int ll = neighboorLight & 0xF;
            int rl = neighboorLight & 0x1E0;
            int gl = neighboorLight & 0x3C00;
            int bl = neighboorLight & 0x78000;
            rl -= 32 * opacity;
            gl -= 1024 * opacity;
            bl -= 32768 * opacity;
            if ((ll -= opacity) > (currentLight & 0xF)) {
                currentLight = currentLight & 0x7BDE0 | ll;
            }
            if (rl > (currentLight & 0x1E0)) {
                currentLight = currentLight & 0x7BC0F | rl;
            }
            if (gl > (currentLight & 0x3C00)) {
                currentLight = currentLight & 0x781EF | gl;
            }
            if (bl <= (currentLight & 0x78000)) continue;
            currentLight = currentLight & 0x3DEF | bl;
        }
        return currentLight;
    }

    public static boolean updateLightByType(World world, EnumSkyBlock par1Enu, int x, int y, int z) {
        int z2;
        int y2;
        int x2;
        int expectedEntryLight;
        int lightEntry;
        int z1;
        int y1;
        int x1;
        long l1;
        if (!world.func_72873_a(x, y, z, 17)) {
            return false;
        }
        int l = 0;
        int i1 = 0;
        world.field_72984_F.func_76320_a("getBrightness");
        int savedLightValue = world.func_72972_b(par1Enu, x, y, z);
        int compLightValue = CLWorldHelper.computeLightValue(world, x, y, z, par1Enu);
        if (compLightValue > savedLightValue) {
            CLWorldHelper.lightUpdateBlockList[i1++] = 133152L;
        } else if (compLightValue < savedLightValue) {
            CLWorldHelper.lightUpdateBlockList[i1++] = 0x20820 | savedLightValue << 18;
            while (l < i1) {
                l1 = lightUpdateBlockList[l++];
                x1 = (int)(l1 & 0x3FL) - 32 + x;
                y1 = (int)(l1 >> 6 & 0x3FL) - 32 + y;
                z1 = (int)(l1 >> 12 & 0x3FL) - 32 + z;
                lightEntry = (int)(l1 >>> 18) & 0x7BDEF;
                expectedEntryLight = world.func_72972_b(par1Enu, x1, y1, z1);
                if ((expectedEntryLight & 0xF) < (lightEntry & 0xF)) continue;
                world.func_72915_b(par1Enu, x1, y1, z1, 0);
                if (lightEntry <= 0 || (x2 = MathHelper.func_76130_a((int)(x1 - x))) + (y2 = MathHelper.func_76130_a((int)(y1 - y))) + (z2 = MathHelper.func_76130_a((int)(z1 - z))) >= 17) continue;
                for (int faceIndex = 0; faceIndex < 6; ++faceIndex) {
                    int xFace = x1 + Facing.field_71586_b[faceIndex];
                    int yFace = y1 + Facing.field_71587_c[faceIndex];
                    int zFace = z1 + Facing.field_71585_d[faceIndex];
                    int blockOpacity = world.func_147439_a(xFace, yFace, zFace).getLightOpacity((IBlockAccess)world, xFace, yFace, zFace);
                    int opacity = Math.max(1, blockOpacity);
                    expectedEntryLight = world.func_72972_b(par1Enu, xFace, yFace, zFace);
                    int ll = lightEntry & 0xF;
                    int rl = lightEntry & 0x1E0;
                    int gl = lightEntry & 0x3C00;
                    int bl = lightEntry & 0x78000;
                    rl -= 32 * opacity;
                    gl -= 1024 * opacity;
                    bl -= 32768 * opacity;
                    if ((expectedEntryLight & 0xF) < (ll -= opacity) || i1 >= lightUpdateBlockList.length) continue;
                    CLWorldHelper.lightUpdateBlockList[i1++] = xFace - x + 32 | yFace - y + 32 << 6 | zFace - z + 32 << 12 | (ll | rl | gl | bl) << 18;
                }
            }
            l = 0;
        }
        world.field_72984_F.func_76319_b();
        world.field_72984_F.func_76320_a("checkedPosition < toCheckCount");
        while (l < i1) {
            boolean flag;
            l1 = lightUpdateBlockList[l++];
            x1 = (int)(l1 & 0x3FL) - 32 + x;
            y1 = (int)(l1 >> 6 & 0x3FL) - 32 + y;
            z1 = (int)(l1 >> 12 & 0x3FL) - 32 + z;
            lightEntry = world.func_72972_b(par1Enu, x1, y1, z1);
            expectedEntryLight = CLWorldHelper.computeLightValue(world, x1, y1, z1, par1Enu);
            if (expectedEntryLight == lightEntry) continue;
            int tempStorageLightValue = lightEntry;
            if ((expectedEntryLight & 0xF) > (lightEntry & 0xF)) {
                tempStorageLightValue = tempStorageLightValue & 0x7BDE0 | expectedEntryLight & 0xF;
            }
            if ((expectedEntryLight & 0x1E0) > (lightEntry & 0x1E0)) {
                tempStorageLightValue = tempStorageLightValue & 0x7BC0F | expectedEntryLight & 0x1E0;
            }
            if ((expectedEntryLight & 0x3C00) > (lightEntry & 0x3C00)) {
                tempStorageLightValue = tempStorageLightValue & 0x781EF | expectedEntryLight & 0x3C00;
            }
            if ((expectedEntryLight & 0x78000) > (lightEntry & 0x78000)) {
                tempStorageLightValue = tempStorageLightValue & 0x3DEF | expectedEntryLight & 0x78000;
            }
            if (((0x100000 | lightEntry) - expectedEntryLight & 0x84210) <= 0) continue;
            world.func_72915_b(par1Enu, x1, y1, z1, tempStorageLightValue);
            x2 = Math.abs(x1 - x);
            y2 = Math.abs(y1 - y);
            z2 = Math.abs(z1 - z);
            boolean bl = flag = i1 < lightUpdateBlockList.length - 6;
            if (x2 + y2 + z2 >= 17 || !flag) continue;
            if (((0x100000 | world.func_72972_b(par1Enu, x1 - 1, y1, z1)) - expectedEntryLight & 0x84210) > 0) {
                CLWorldHelper.lightUpdateBlockList[i1++] = x1 - 1 - x + 32 + (y1 - y + 32 << 6) + (z1 - z + 32 << 12);
            }
            if (((0x100000 | world.func_72972_b(par1Enu, x1 + 1, y1, z1)) - expectedEntryLight & 0x84210) > 0) {
                CLWorldHelper.lightUpdateBlockList[i1++] = x1 + 1 - x + 32 + (y1 - y + 32 << 6) + (z1 - z + 32 << 12);
            }
            if (((0x100000 | world.func_72972_b(par1Enu, x1, y1 - 1, z1)) - expectedEntryLight & 0x84210) > 0) {
                CLWorldHelper.lightUpdateBlockList[i1++] = x1 - x + 32 + (y1 - 1 - y + 32 << 6) + (z1 - z + 32 << 12);
            }
            if (((0x100000 | world.func_72972_b(par1Enu, x1, y1 + 1, z1)) - expectedEntryLight & 0x84210) > 0) {
                CLWorldHelper.lightUpdateBlockList[i1++] = x1 - x + 32 + (y1 + 1 - y + 32 << 6) + (z1 - z + 32 << 12);
            }
            if (((0x100000 | world.func_72972_b(par1Enu, x1, y1, z1 - 1)) - expectedEntryLight & 0x84210) > 0) {
                CLWorldHelper.lightUpdateBlockList[i1++] = x1 - x + 32 + (y1 - y + 32 << 6) + (z1 - 1 - z + 32 << 12);
            }
            if (((0x100000 | world.func_72972_b(par1Enu, x1, y1, z1 + 1)) - expectedEntryLight & 0x84210) <= 0) continue;
            CLWorldHelper.lightUpdateBlockList[i1++] = x1 - x + 32 + (y1 - y + 32 << 6) + (z1 + 1 - z + 32 << 12);
        }
        world.field_72984_F.func_76319_b();
        return true;
    }
}

