/*
 * Decompiled with CFR 0.152.
 */
package com.throwable.Handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomEventHandler {
    private static final int MAX_BLOCKS = 49;
    private static final int TICK_DELAY = 200;
    private static int tick = 0;
    private static int marker = -1;
    private static int[] xPos = new int[49];
    private static int[] yPos = new int[49];
    private static int[] zPos = new int[49];
    private static float[] dmg = new float[49];

    public static void damageBlock(World world, int x, int y, int z, EntityPlayer player, ItemStack stack, float factor) {
        if (!world.field_72995_K) {
            int index = -1;
            for (int i = 0; i < xPos.length; ++i) {
                if (x != xPos[i] || y != yPos[i] || z != zPos[i]) continue;
                index = i;
                break;
            }
            if (index < 0) {
                index = marker = ++marker < 49 ? marker : 0;
                CustomEventHandler.xPos[index] = x;
                CustomEventHandler.yPos[index] = y;
                CustomEventHandler.zPos[index] = z;
            }
            Block block = world.func_147439_a(x, y, z);
            int blockId = Block.func_149682_b((Block)block);
            int metadata = world.func_72805_g(x, y, z);
            if (block.func_149688_o() != Material.field_151579_a) {
                int n = index;
                dmg[n] = dmg[n] + factor * CustomEventHandler.blockStrength(world, player, block, metadata, x, y, z, stack);
                if (dmg[index] < 1.0f) {
                    world.func_147443_d(blockId, x, y, z, (int)(dmg[index] * 10.0f) - 1);
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_149762_H.func_150498_e(), block.field_149762_H.func_150497_c() * 1.5f, block.field_149762_H.func_150494_d() * 0.5f);
                } else if (world.func_147468_f(x, y, z)) {
                    CustomEventHandler.dmg[index] = 0.0f;
                    world.func_72926_e(2001, x, y, z, blockId + (metadata << 12));
                    if (!player.field_71075_bZ.field_75098_d && CustomEventHandler.canHarvestBlock(world, player, block, metadata, stack)) {
                        block.func_149697_b(world, x, y, z, metadata, 0);
                    }
                }
            }
        }
    }

    public static float blockStrength(World world, EntityPlayer player, Block block, int metadata, int x, int y, int z, ItemStack stack) {
        float hardness = block.func_149712_f(world, x, y, z);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!CustomEventHandler.canHarvestBlock(world, player, block, metadata, stack)) {
            return CustomEventHandler.getBreakSpeed(player, block, metadata, x, y, z, stack) / hardness / 100.0f;
        }
        return CustomEventHandler.getBreakSpeed(player, block, metadata, x, y, z, stack) / hardness / 30.0f;
    }

    public static boolean canHarvestBlock(World world, EntityPlayer player, Block block, int metadata, ItemStack stack) {
        if (block.func_149688_o().func_76229_l()) {
            return true;
        }
        String tool = block.getHarvestTool(metadata);
        if (stack == null || tool == null) {
            return player.func_146099_a(block);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool);
        if (toolLevel < 0) {
            return player.func_146099_a(block);
        }
        return toolLevel >= block.getHarvestLevel(metadata);
    }

    public static float getBreakSpeed(EntityPlayer player, Block block, int metadata, int x, int y, int z, ItemStack stack) {
        int mod;
        float f;
        float f2 = f = stack == null ? 1.0f : stack.func_77973_b().getDigSpeed(stack, block, metadata);
        if (f > 1.0f && (mod = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)stack)) > 0 && stack != null) {
            float f1 = mod * mod + 1;
            f = !ForgeHooks.canToolHarvestBlock((Block)block, (int)metadata, (ItemStack)stack) && f <= 1.0f ? (f += f1 * 0.08f) : (f += f1);
        }
        if (player.func_70644_a(Potion.field_76422_e)) {
            f *= 1.0f + (float)(player.func_70660_b(Potion.field_76422_e).func_76458_c() + 1) * 0.2f;
        }
        if (player.func_70644_a(Potion.field_76419_f)) {
            f *= 1.0f - (float)(player.func_70660_b(Potion.field_76419_f).func_76458_c() + 1) * 0.2f;
        }
        if (player.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)player)) {
            f /= 5.0f;
        }
        if (!player.field_70122_E) {
            f /= 5.0f;
        }
        return (f = ForgeEventFactory.getBreakSpeed((EntityPlayer)player, (Block)block, (int)metadata, (float)f, (int)x, (int)y, (int)z)) < 0.0f ? 0.0f : f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (marker > -1) {
            if (tick < 200) {
                ++tick;
            } else {
                tick = 0;
                for (int i = 0; i < dmg.length; ++i) {
                    if (!(dmg[i] < 1.0f)) continue;
                    event.world.func_147443_d(-(i + 1), xPos[i], yPos[i], zPos[i], (int)(dmg[i] * 10.0f) - 1);
                }
            }
        }
    }
}

