package com.kegare.skyland.world.gen;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

/*
 * Skyland
 *
 * Copyright (c) 2014 kegare
 * https://github.com/kegare
 *
 * This mod is distributed under the terms of the Minecraft Mod Public License Japanese Translation, or MMPL_J.
 */

public class WorldGenSkylandStone extends WorldGenerator
{
	@Override
	public boolean generate(World world, Random random, int x, int y, int z)
	{
		float f = random.nextFloat() * (float)Math.PI;
		int size = 60;
		double d0 = x + 8 + MathHelper.sin(f) * size / 8.0F;
		double d1 = x + 8 - MathHelper.sin(f) * size / 8.0F;
		double d2 = z + 8 + MathHelper.cos(f) * size / 8.0F;
		double d3 = z + 8 - MathHelper.cos(f) * size / 8.0F;
		double d4 = y + random.nextInt(3) - 2;
		double d5 = y + random.nextInt(3) - 2;

		for (int l = 0; l <= size; ++l)
		{
			double d6 = d0 + (d1 - d0) * l / size;
			double d7 = d4 + (d5 - d4) * l / size;
			double d8 = d2 + (d3 - d2) * l / size;
			double d9 = random.nextDouble() * size / 16.0D;
			double d10 = (MathHelper.sin(l * (float)Math.PI / size) + 1.0F) * d9 + 1.0D;
			double d11 = (MathHelper.sin(l * (float)Math.PI / size) + 1.0F) * d9 + 1.0D;

			for (int i = MathHelper.floor_double(d6 - d10 / 2.0D); i <= MathHelper.floor_double(d6 + d10 / 2.0D); ++i)
			{
				double xScale = (i + 0.5D - d6) / (d10 / 2.0D);

				if (xScale * xScale < 1.0D)
				{
					for (int j = MathHelper.floor_double(d7 - d11 / 2.0D); j <= MathHelper.floor_double(d7 + d11 / 2.0D); ++j)
					{
						double yScale = (j + 0.5D - d7) / (d11 / 2.0D);

						if (xScale * xScale + yScale * yScale < 1.0D)
						{
							for (int k = MathHelper.floor_double(d8 - d10 / 2.0D); k <= MathHelper.floor_double(d8 + d10 / 2.0D); ++k)
							{
								double zScale = (k + 0.5D - d8) / (d10 / 2.0D);

								if (xScale * xScale + yScale * yScale + zScale * zScale < 1.0D && world.getBlock(i, j, k).isReplaceableOreGen(world, i, j, k, Blocks.dirt))
								{
									Block block = world.getBlock(i, j + 1, k);

									if (block != Blocks.grass && !block.isWood(world, i, j + 1, k))
									{
										world.setBlock(i, j, k, Blocks.stone, 0, 2);
									}
								}
							}
						}
					}
				}
			}
		}

		return true;
	}
}