/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.bpt.proxy;

import com.mrdimka.bpt.BiomePaintTools;
import com.mrdimka.bpt.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Level;

public class ClientProxy
extends CommonProxy {
    public static List<ISound> SOUNDS = new ArrayList<ISound>();

    @Override
    public void init() {
        ClientProxy.registerRenders(BiomePaintTools.items);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderHUD(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            float x;
            byte biome;
            String bn;
            FontRenderer f = Minecraft.func_71410_x().field_71466_p;
            ItemStack mainhand = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            ItemStack offhand = Minecraft.func_71410_x().field_71439_g.func_184592_cb();
            EnumHandSide handMain = Minecraft.func_71410_x().field_71474_y.field_186715_A;
            if (mainhand != null && mainhand.func_77973_b() == BiomePaintTools.pencil && mainhand.func_77942_o() && mainhand.func_77978_p().func_74764_b("CurrentBiome") && mainhand.func_77952_i() < BiomePaintTools.pencil.func_77612_l()) {
                bn = I18n.func_74838_a((String)"hud.biomepainttools:biome_name") + ": ";
                biome = (byte)mainhand.func_77978_p().func_74762_e("CurrentBiome");
                bn = bn + I18n.func_74838_a((String)Biome.func_150568_d((int)biome).func_185359_l());
                x = handMain == EnumHandSide.LEFT ? 2.0f : (float)e.getResolution().func_78327_c() - (float)f.func_78256_a(bn) - 2.0f;
                f.func_175065_a(bn, x, (float)e.getResolution().func_78324_d() / 2.0f - 14.0f, 0xFFFFFF, false);
            }
            if (offhand != null && offhand.func_77973_b() == BiomePaintTools.pencil && offhand.func_77942_o() && offhand.func_77978_p().func_74764_b("CurrentBiome") && offhand.func_77952_i() < BiomePaintTools.pencil.func_77612_l()) {
                bn = I18n.func_74838_a((String)"hud.biomepainttools:biome_name") + ": ";
                biome = (byte)offhand.func_77978_p().func_74762_e("CurrentBiome");
                bn = bn + I18n.func_74838_a((String)Biome.func_150568_d((int)biome).func_185359_l());
                x = handMain == EnumHandSide.LEFT ? (float)e.getResolution().func_78327_c() - (float)f.func_78256_a(bn) - 2.0f : 2.0f;
                f.func_175065_a(bn, x, (float)e.getResolution().func_78324_d() / 2.0f - 14.0f, 0xFFFFFF, false);
            }
        }
    }

    @SubscribeEvent
    public void pushSounds(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            while (SOUNDS.size() > 0) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a(SOUNDS.remove(0));
            }
        }
    }

    @Override
    public void setBiomeAt(World world, BlockPos pos, byte biome) {
        if (world.field_72995_K && world.func_175707_a(pos, pos)) {
            int x = Math.abs(pos.func_177958_n() < 0 ? (16 + pos.func_177958_n()) % 16 : pos.func_177958_n() % 16) % 16;
            int z = Math.abs(pos.func_177952_p() < 0 ? (16 + pos.func_177952_p()) % 16 : pos.func_177952_p() % 16) % 16;
            Chunk c = world.func_175726_f(pos);
            byte[] biomes = c.func_76605_m();
            biomes[x + z * 16] = biome;
            c.func_76616_a(biomes);
            for (int y = 0; y < 256; ++y) {
                world.func_175704_b(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()), new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()));
            }
        } else {
            super.setBiomeAt(world, pos, biome);
        }
    }

    public static void registerRenders(Iterable<Item> items) {
        Iterator<Item> it = items.iterator();
        while (it.hasNext()) {
            ClientProxy.registerRender(it.next(), 0);
        }
    }

    public static void registerRenders(Item ... items) {
        for (Item i : items) {
            ClientProxy.registerRender(i, 0);
        }
    }

    public static void registerRender(Item item, int meta) {
        FMLLog.log((String)"Biome Paint Tools", (Level)Level.INFO, (String)("Model definition for location " + item.func_77658_a().substring(5) + ":" + meta), (Object[])new Object[0]);
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation(item.func_77658_a().substring(5) + (meta <= 0 ? "" : "_" + meta), "inventory"));
    }

    @Override
    public void playSound_client(String sound, int dim, int x, int y, int z, SoundCategory cat, float vol, float pitch) {
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == dim) {
            SOUNDS.add((ISound)new PositionedSoundRecord(new ResourceLocation(sound), cat, vol, pitch, false, 0, ISound.AttenuationType.LINEAR, (float)x, (float)y, (float)z));
        }
    }
}

