/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.audio;

import com.mrdimka.hammercore.client.audio.MicrophoneSetup;
import java.io.ByteArrayOutputStream;

public class Recorder
implements Runnable {
    private static int recorders = 0;
    public final Thread asThread = new Thread(this);
    public boolean recording = true;
    public boolean running = false;
    public int packetMaxSize = 8000;
    public Function<byte[]> onReRecord1;
    public Function<ByteArrayOutputStream> onReRecord2;

    public Recorder() {
        this.asThread.setName("HammerCoreMicrophoneRecorder#" + recorders);
        ++recorders;
    }

    public void start() {
        this.asThread.start();
    }

    @Override
    public void run() {
        this.running = true;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (this.running && this.recordPiece(baos)) {
        }
    }

    public boolean recordPiece(ByteArrayOutputStream baos) {
        if (this.recording) {
            try {
                MicrophoneSetup.captureMic(baos, this.packetMaxSize, false);
                if (this.onReRecord1 != null) {
                    this.onReRecord1.call(baos.toByteArray());
                }
                if (this.onReRecord2 != null) {
                    this.onReRecord2.call(baos);
                }
                baos.reset();
            }
            catch (Throwable err) {
                return false;
            }
        }
        try {
            Thread.sleep(5L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static interface Function<V> {
        public void call(V var1);
    }
}

