/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore;

import com.mrdimka.hammercore.annotations.MCFBus;
import com.mrdimka.hammercore.common.utils.AnnotatedInstanceUtil;
import com.mrdimka.hammercore.common.utils.HammerCoreUtils;
import com.mrdimka.hammercore.init.ModItems;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.proxy.AudioProxy_Common;
import com.mrdimka.hammercore.proxy.ParticleProxy_Common;
import com.mrdimka.hammercore.proxy.RenderProxy_Common;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

@Mod(modid="hammercore", version="1.1.8", name="Hammer Core", acceptedMinecraftVersions="[1.10.2]")
public class HammerCore {
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.RenderProxy_Client", serverSide="com.mrdimka.hammercore.proxy.RenderProxy_Common")
    public static RenderProxy_Common renderProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.AudioProxy_Client", serverSide="com.mrdimka.hammercore.proxy.AudioProxy_Common")
    public static AudioProxy_Common audioProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.ParticleProxy_Client", serverSide="com.mrdimka.hammercore.proxy.ParticleProxy_Common")
    public static ParticleProxy_Common particleProxy;
    @Mod.Instance(value="hammercore")
    public static HammerCore instance;
    public static final CreativeTabs tab;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent e) {
        renderProxy.construct();
        audioProxy.construct();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        List<Object> toRegister = AnnotatedInstanceUtil.getInstances(e.getAsmData(), MCFBus.class, Object.class);
        for (Object o : toRegister) {
            MinecraftForge.EVENT_BUS.register(o);
            FMLLog.log((String)"Hammer Core", (Level)Level.INFO, (String)("Added \"" + o + "\" to MCF Event Bus."), (Object[])new Object[0]);
        }
        FMLLog.log((String)"Hammer Core", (Level)Level.INFO, (String)("Added " + toRegister.size() + " object to MCF Event Bus."), (Object[])new Object[0]);
        new ModItems();
        ModMetadata meta = e.getModMetadata();
        meta.autogenerated = false;
        meta.version = "1.1.8";
        meta.updateJSON = "https://mrdimkasstudio.github.io/UpdateJSONs/HammerCore.json";
        meta.authorList = Arrays.asList("MrDimkas_Studio");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        renderProxy.init();
        HCNetwork.clinit();
    }

    static {
        tab = HammerCoreUtils.createDynamicCreativeTab("hammercore", 150);
    }
}

