/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

public class CursorHandler {
    public static Cursor makeCursor(BufferedImage buf, int xHotspot, int yHotspot) {
        if (buf.getType() != 2) {
            BufferedImage b = new BufferedImage(buf.getWidth(), buf.getHeight(), 2);
            b.createGraphics().drawImage((Image)buf, 0, 0, null);
            buf = b;
        }
        try {
            Cursor cursor = new Cursor(buf.getWidth(), buf.getHeight(), xHotspot, yHotspot, 1, IntBuffer.wrap(((DataBufferInt)buf.getRaster().getDataBuffer()).getData()), IntBuffer.wrap(new int[1]));
            return cursor;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Cursor setCursor(BufferedImage buf, int xHotspot, int yHotspot) {
        try {
            Cursor cursor = CursorHandler.makeCursor(buf, xHotspot, yHotspot);
            CursorHandler.setCursor(cursor);
            return cursor;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setCursor(Cursor c) {
        try {
            Mouse.setNativeCursor((Cursor)c);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }
}

