/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.inventory;

import com.mrdimka.hammercore.common.inventory.IInventoryListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class InventoryNonTile
implements IInventory {
    public IInventoryListener listener;
    public ItemStack[] inventory = new ItemStack[0];
    private final int[] allSlots;
    public int inventoryStackLimit = 64;
    public NBTTagCompound boundCompound = new NBTTagCompound();

    public InventoryNonTile(int inventorySize, NBTTagCompound boundNBT) {
        this.inventory = new ItemStack[inventorySize];
        this.allSlots = new int[this.inventory.length];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
        this.boundCompound = boundNBT;
    }

    public InventoryNonTile(NBTTagCompound boundNBT, ItemStack ... items) {
        this.inventory = items;
        this.allSlots = new int[this.inventory.length];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
        this.boundCompound = boundNBT;
    }

    public InventoryNonTile(int inventorySize) {
        this.inventory = new ItemStack[inventorySize];
        this.allSlots = new int[this.inventory.length];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public InventoryNonTile(ItemStack ... items) {
        this.inventory = items;
        this.allSlots = new int[this.inventory.length];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public int[] getAllAvaliableSlots() {
        return this.allSlots;
    }

    public String func_70005_c_() {
        return "Inventory Non Tile Entity";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        try {
            return this.inventory[index];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public ItemStack func_70298_a(int slot, int count) {
        try {
            if (this.inventory[slot] != null) {
                if (this.inventory[slot].field_77994_a <= count) {
                    ItemStack is = this.inventory[slot];
                    this.inventory[slot] = null;
                    if (this.listener != null) {
                        this.listener.slotChange(count, this.inventory[slot]);
                    }
                    return is;
                }
                ItemStack is = this.inventory[slot].func_77979_a(count);
                if (this.inventory[slot].field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
                if (this.listener != null) {
                    this.listener.slotChange(count, this.inventory[slot]);
                }
                return is;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        try {
            this.inventory[index] = stack;
            if (this.listener != null) {
                this.listener.slotChange(index, stack);
            }
            if (this.inventory[index].field_77994_a > Math.min(this.inventory[index].func_77976_d(), this.func_70297_j_())) {
                this.inventory[index].field_77994_a = Math.min(this.inventory[index].func_77976_d(), this.func_70297_j_());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int func_70297_j_() {
        return this.inventoryStackLimit;
    }

    public void func_70296_d() {
        this.writeToNBT();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean isUseableByPlayer(EntityPlayer player, BlockPos from) {
        return player.func_174818_b(from) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory = new ItemStack[this.inventory.length];
        if (this.listener != null) {
            for (int i = 0; i < this.inventory.length; ++i) {
                this.listener.slotChange(i, this.inventory[i]);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_74768_a("InvSize", this.inventory.length);
            for (int id = 0; id < this.inventory.length; ++id) {
                if (this.inventory[id] == null || this.inventory[id].field_77994_a < 1) continue;
                NBTTagCompound itemCompound = new NBTTagCompound();
                this.inventory[id].func_77955_b(itemCompound);
                nbt.func_74782_a("Inv" + id, (NBTBase)itemCompound);
            }
        }
    }

    public void writeToNBT() {
        this.writeToNBT(this.boundCompound);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            int size = nbt.func_74762_e("InvSize");
            this.inventory = new ItemStack[size];
            for (int id = 0; id < size; ++id) {
                NBTTagCompound nbtItem = nbt.func_74775_l("Inv" + id);
                if (nbtItem.func_82582_d()) continue;
                this.inventory[id] = ItemStack.func_77949_a((NBTTagCompound)nbtItem);
            }
        }
    }

    public void readFromNBT() {
        this.readFromNBT(this.boundCompound);
    }

    public void drop(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            for (ItemStack s : this.inventory) {
                if (s == null) continue;
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, s));
            }
        }
        this.func_174888_l();
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack s = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        if (this.listener != null) {
            this.listener.slotChange(slot, null);
        }
        return s;
    }
}

