/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.net.packetAPI;

import com.mrdimka.hammercore.net.packetAPI.IPacket;
import com.mrdimka.hammercore.net.packetAPI.IPacketListener;
import com.mrdimka.hammercore.net.packetAPI.PacketManager;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCustomNBT
implements IMessage,
IMessageHandler<PacketCustomNBT, IMessage> {
    public NBTTagCompound nbt = new NBTTagCompound();

    PacketCustomNBT(IPacket packet, String channel) {
        NBTTagCompound nbt = new NBTTagCompound();
        packet.writeToNBT(nbt);
        this.nbt.func_74782_a("PacketData", (NBTBase)nbt);
        this.nbt.func_74778_a("PacketClass", packet.getClass().getName());
        this.nbt.func_74778_a("Channel", channel);
    }

    public PacketCustomNBT() {
    }

    public IMessage onMessage(PacketCustomNBT message, MessageContext ctx) {
        try {
            NBTTagCompound nbt = message.nbt;
            PacketManager mgr = PacketManager.getManagerByChannel(message.nbt.func_74779_i("Channel"));
            Class<?> packetClass = Class.forName(nbt.func_74779_i("PacketClass"));
            IPacketListener<?, ?> listener = mgr.stringClassRegistry.get(packetClass.getName());
            IPacket packet = (IPacket)packetClass.newInstance();
            packet.readFromNBT(nbt.func_74775_l("PacketData"));
            Object pkt = listener.onArrived(packet, ctx);
            if (pkt != null) {
                return new PacketCustomNBT((IPacket)pkt, nbt.func_74779_i("Channel"));
            }
        }
        catch (Throwable err) {
            System.out.println("Can't handle packet for class " + message.nbt.func_74779_i("PacketClass"));
            err.printStackTrace();
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        byte[] nbtBytes = new byte[buf.readInt()];
        buf.readBytes(nbtBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(nbtBytes);
        try {
            this.nbt = CompressedStreamTools.func_74796_a((InputStream)bais);
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        try {
            bais.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.nbt, (OutputStream)baos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byte[] data = baos.toByteArray();
        buf.writeInt(data.length);
        buf.writeBytes(data);
    }
}

