/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.net.packetAPI;

import com.mrdimka.hammercore.net.packetAPI.IPacket;
import com.mrdimka.hammercore.net.packetAPI.IPacketListener;
import com.mrdimka.hammercore.net.packetAPI.PacketCustomNBT;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketManager {
    private static final Map<String, PacketManager> managers = new HashMap<String, PacketManager>();
    final Map<Class<? extends IPacket>, IPacketListener<?, ?>> registry = new HashMap();
    final Map<String, IPacketListener<?, ?>> stringClassRegistry = new HashMap();
    private final SimpleNetworkWrapper wrapper;
    final String channel;

    public PacketManager(String channel) {
        if (PacketManager.getManagerByChannel(channel) != null) {
            throw new RuntimeException("Duplicate channel ID for " + channel + " (" + this + ") and (" + PacketManager.getManagerByChannel(channel) + ")!!!");
        }
        managers.put(channel, this);
        this.channel = channel;
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel("hammercore" + channel);
        this.wrapper.registerMessage(PacketCustomNBT.class, PacketCustomNBT.class, 1, Side.CLIENT);
        this.wrapper.registerMessage(PacketCustomNBT.class, PacketCustomNBT.class, 1, Side.SERVER);
    }

    public String getChannel() {
        return this.channel;
    }

    public static PacketManager getManagerByChannel(String channel) {
        return managers.get(channel);
    }

    public <PKT extends IPacket, REPLY extends IPacket> void registerPacket(Class<PKT> packet, IPacketListener<PKT, REPLY> listener) {
        this.registry.put(packet, listener);
        this.stringClassRegistry.put(packet.getName(), listener);
    }

    public void sendToAll(IPacket packet) {
        this.wrapper.sendToAll((IMessage)new PacketCustomNBT(packet, this.channel));
    }

    public void sendTo(IPacket packet, EntityPlayerMP player) {
        this.wrapper.sendTo((IMessage)new PacketCustomNBT(packet, this.channel), player);
    }

    public void sendToAllAround(IPacket packet, NetworkRegistry.TargetPoint point) {
        this.wrapper.sendToAllAround((IMessage)new PacketCustomNBT(packet, this.channel), point);
    }

    public void sendToDimension(IPacket packet, int dimensionId) {
        this.wrapper.sendToDimension((IMessage)new PacketCustomNBT(packet, this.channel), dimensionId);
    }

    public void sendToServer(IPacket packet) {
        this.wrapper.sendToServer((IMessage)new PacketCustomNBT(packet, this.channel));
    }
}

