/*
 * Decompiled with CFR 0.152.
 */
package troy.chunkborders;

import com.google.gson.annotations.Expose;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.modconfig.ConfigStrategy;
import com.mumfrey.liteloader.modconfig.Exposable;
import com.mumfrey.liteloader.modconfig.ExposableOptions;
import org.lwjgl.opengl.GL11;
import troy.chunkborders.Height;

@ExposableOptions(strategy=ConfigStrategy.Unversioned, filename="chunkborders.json")
public class BorderRenderer
implements Exposable {
    @Expose
    public int radius = 2;
    @Expose
    public float lineRed = 1.0f;
    @Expose
    public float lineGreen = 0.6f;
    @Expose
    public float lineBlue = 0.0f;
    @Expose
    public Height heightSetting = Height.AUTO;
    @Expose
    public boolean spawnChunks = false;
    public double[][] spawnChunkCorners = new double[4][2];
    private double renderHeight = 64.0;
    private apx[] borderizedChunks;
    private int prevChunkX = 0;
    private int prevChunkZ = 0;
    private boolean enabled = false;
    private boolean updateChunks = false;

    public void render(bao minecraft, float partialTicks) {
        if (this.enabled) {
            bjk player = minecraft.h;
            bjf world = minecraft.f;
            if (this.prevChunkX != player.ah || this.prevChunkZ != player.aj || this.borderizedChunks == null || this.updateChunks) {
                this.updateChunks = false;
                this.prevChunkX = player.ah;
                this.prevChunkZ = player.aj;
                this.updateChunkList((ahb)world, minecraft.h, this.radius);
            }
            double x = player.p + (player.s - player.p) * (double)partialTicks;
            double y = player.q + (player.t - player.q) * (double)partialTicks;
            double z = player.r + (player.u - player.r) * (double)partialTicks;
            double renderY = this.heightSetting == Height.MANUAL ? this.renderHeight + 0.05 : Math.floor(player.C.b) + 0.05;
            bam.a();
            buu.a((int)buu.c, (float)240.0f, (float)240.0f);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)1.0f);
            GL11.glDepthMask((boolean)false);
            GL11.glPushMatrix();
            GL11.glColor4f((float)this.lineRed, (float)this.lineGreen, (float)this.lineBlue, (float)0.75f);
            bmh tesselator = bmh.a;
            for (apx chunk : this.borderizedChunks) {
                if (chunk == null) {
                    this.updateChunks = true;
                    continue;
                }
                tesselator.a(2);
                tesselator.a((double)(chunk.g * 16) - x, renderY - y, (double)(chunk.h * 16) - z);
                tesselator.a((double)(chunk.g * 16 + 16) - x, renderY - y, (double)(chunk.h * 16) - z);
                tesselator.a((double)(chunk.g * 16 + 16) - x, renderY - y, (double)(chunk.h * 16 + 16) - z);
                tesselator.a((double)(chunk.g * 16) - x, renderY - y, (double)(chunk.h * 16 + 16) - z);
                tesselator.a();
            }
            if (this.spawnChunks && this.isPosInRenderableArea(player, world.N().c(), world.N().e())) {
                this.renderSpawnArea((ahb)world, x, y, z, renderY);
                this.renderSpawnChunks((ahb)world, x, y, z, renderY);
            }
            GL11.glDepthFunc((int)515);
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            bam.b();
        }
    }

    public void renderSpawnArea(ahb world, double x, double y, double z, double renderY) {
        int spawnX = world.N().c();
        int spawnZ = world.N().e();
        bmh tesselator = bmh.a;
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        tesselator.a(2);
        tesselator.a((double)(spawnX + 10) - x, renderY - y + 0.1, (double)(spawnZ + 10) - z);
        tesselator.a((double)(spawnX + 10) - x, renderY - y + 0.1, (double)(spawnZ - 10) - z);
        tesselator.a((double)(spawnX - 10) - x, renderY - y + 0.1, (double)(spawnZ - 10) - z);
        tesselator.a((double)(spawnX - 10) - x, renderY - y + 0.1, (double)(spawnZ + 10) - z);
        tesselator.a();
    }

    public void renderSpawnChunks(ahb world, double x, double y, double z, double renderY) {
        bmh tesselator = bmh.a;
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tesselator.a(2);
        tesselator.a(this.spawnChunkCorners[0][0] - x, renderY - y + 0.1, this.spawnChunkCorners[0][1] - z);
        tesselator.a(this.spawnChunkCorners[1][0] - x, renderY - y + 0.1, this.spawnChunkCorners[1][1] - z);
        tesselator.a(this.spawnChunkCorners[2][0] - x, renderY - y + 0.1, this.spawnChunkCorners[2][1] - z);
        tesselator.a(this.spawnChunkCorners[3][0] - x, renderY - y + 0.1, this.spawnChunkCorners[3][1] - z);
        tesselator.a();
    }

    public void updateChunkList(ahb world, bjk player, int radius) {
        int startChunkX = player.ah - radius;
        int startChunkZ = player.aj - radius;
        int sideLength = radius * 2 + 1;
        this.borderizedChunks = new apx[sideLength * sideLength];
        int currentIndex = 0;
        for (int row = 0; row < sideLength; ++row) {
            for (int column = 0; column < sideLength; ++column) {
                apx chunk = world.e(startChunkX + row, startChunkZ + column);
                if (!chunk.d) continue;
                this.borderizedChunks[currentIndex] = chunk;
                ++currentIndex;
            }
        }
    }

    public void updateSpawnChunks(ahb world) {
        boolean centerChunk = false;
        if ((double)world.N().c() / 16.0 % 0.5 == 0.0 && (double)world.N().e() / 16.0 % 0.5 == 0.0) {
            centerChunk = true;
        }
        int midX = Math.round(world.N().c() / 16) * 16;
        int midZ = Math.round(world.N().e() / 16) * 16;
        this.spawnChunkCorners[0][0] = midX + 96 + (centerChunk ? 16 : 0);
        this.spawnChunkCorners[0][1] = midZ + 96 + (centerChunk ? 16 : 0);
        this.spawnChunkCorners[1][0] = midX + 96 + (centerChunk ? 16 : 0);
        this.spawnChunkCorners[1][1] = midZ - 96;
        this.spawnChunkCorners[2][0] = midX - 96;
        this.spawnChunkCorners[2][1] = midZ - 96;
        this.spawnChunkCorners[3][0] = midX - 96;
        this.spawnChunkCorners[3][1] = midZ + 96 + (centerChunk ? 16 : 0);
    }

    public boolean isPosInRenderableArea(bjk player, int posX, int posZ) {
        return BorderRenderer.getDistanceSq(player.s, player.u, posX, posZ) < 36864.0;
    }

    public static double getDistanceSq(double x1, double z1, double x2, double z2) {
        double xs = x1 - x2;
        double zs = z1 - z2;
        return xs * xs + zs * zs;
    }

    public void toggleChunkBorders() {
        this.enabled = !this.enabled;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        if (bao.B().f != null && bao.B().h != null) {
            this.updateChunkList((ahb)bao.B().f, bao.B().h, radius);
        }
        LiteLoader.getInstance().writeConfig((Exposable)this);
    }

    public void setHeightSetting(Height newSetting) {
        this.heightSetting = newSetting;
        LiteLoader.getInstance().writeConfig((Exposable)this);
    }

    public void setHeight(double height) {
        this.renderHeight = height;
    }

    public void incHeight() {
        if (this.renderHeight <= 256.0) {
            this.renderHeight += 1.0;
        }
    }

    public void decHeight() {
        if (this.renderHeight >= 0.0) {
            this.renderHeight -= 1.0;
        }
    }
}

