/*
 * Decompiled with CFR 0.152.
 */
package slabcraftmod.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slabcraftmod.api.BlockSC1API;

public abstract class BlockLeavesSlab
extends BlockSlab
implements IShearable {
    public static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockLeavesSlab() {
        super(Material.field_151584_j);
        this.field_149762_H = SoundType.field_185850_c;
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_180632_j(iblockstate.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.OAK)));
        this.func_149713_g(1);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (state.func_185914_p()) {
            return false;
        }
        BlockSlab.EnumBlockHalf side = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        if (pos.func_175727_C(state.func_177984_a()) && !pos.func_180495_p(state.func_177977_b()).func_185896_q() && rand.nextInt(15) == 1) {
            double d0 = (float)state.func_177958_n() + rand.nextFloat();
            double d1 = (double)state.func_177956_o() - 0.05;
            double d2 = (float)state.func_177952_p() + rand.nextFloat();
            pos.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)VARIANT));
        if (type == EnumType.ACACIA) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.ACACIA.getMetadata()));
        }
        if (type == EnumType.BIRCH) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.BIRCH.getMetadata()));
        }
        if (type == EnumType.DARKOAK) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.DARKOAK.getMetadata()));
        }
        if (type == EnumType.JUNGLE) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.JUNGLE.getMetadata()));
        }
        if (type == EnumType.OAK) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.OAK.getMetadata()));
        }
        if (type == EnumType.SPRUCE) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.SPRUCE.getMetadata()));
        }
        return ret;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getUnlocalizedName();
    }

    public IProperty func_176551_l() {
        return VARIANT;
    }

    public Object getVariant(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        if (itemIn != Item.func_150898_a((Block)BlockSC1API.leaves_double)) {
            for (EnumType enumtype : EnumType.values()) {
                list.add(new ItemStack(itemIn, 1, enumtype.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                i |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{SEAMLESS, VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        OAK(0, "leaves_oak_slab"),
        SPRUCE(1, "leaves_spruce_slab"),
        BIRCH(2, "leaves_birch_slab"),
        JUNGLE(3, "leaves_jungle_slab"),
        ACACIA(4, "leaves_acacia_slab"),
        DARKOAK(5, "leaves_dark_oak_slab");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] var0 = EnumType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                EnumType var3;
                EnumType.META_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }

    public static class ColorHandler
    implements IBlockColor,
    IItemColor {
        public int func_186720_a(IBlockState state, IBlockAccess access, BlockPos pos, int tintIndex) {
            return access != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)access, (BlockPos)pos) : ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return this.func_186720_a(null, null, null, tintIndex);
        }
    }
}

