/*
 * Decompiled with CFR 0.152.
 */
package slabcraftmod.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slabcraftmod.api.BlockSC1API;

public abstract class BlockIceSlab
extends BlockSlab {
    public static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockIceSlab() {
        super(Material.field_151588_w);
        this.field_149762_H = SoundType.field_185853_f;
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_180632_j(iblockstate.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.ICE)));
        this.func_149713_g(0);
        this.field_149765_K = 0.98f;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (state.func_185914_p()) {
            return false;
        }
        BlockSlab.EnumBlockHalf side = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_180643_i(state);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                BlockIceSlab.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)is);
            }
        } else {
            if (worldIn.field_73011_w.func_177500_n()) {
                worldIn.func_175698_g(pos);
                return;
            }
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.harvesters.set(player);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
            Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
            if (material.func_76230_c() || material.func_76224_d()) {
                worldIn.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
            }
        }
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getUnlocalizedName();
    }

    public IProperty func_176551_l() {
        return VARIANT;
    }

    public Object getVariant(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        if (itemIn != Item.func_150898_a((Block)BlockSC1API.ice_double)) {
            for (EnumType enumtype : EnumType.values()) {
                list.add(new ItemStack(itemIn, 1, enumtype.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                i |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{SEAMLESS, VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        ICE(0, "ice_slab");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] var0 = EnumType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                EnumType var3;
                EnumType.META_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

