/*
 * Decompiled with CFR 0.152.
 */
package slabcraftmod.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slabcraftmod.api.BlockSC1API;

public abstract class BlockLavaSlab
extends BlockSlab {
    public static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockLavaSlab() {
        super(Material.field_151572_C);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_180632_j(iblockstate.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.LAVA)));
        this.func_149713_g(0);
        this.func_149675_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        Material material;
        double d0 = state.func_177958_n();
        double d1 = state.func_177956_o();
        double d2 = state.func_177952_p();
        if (this.field_149764_J == Material.field_151587_i && pos.func_180495_p(state.func_177984_a()).func_185904_a() == Material.field_151579_a && !pos.func_180495_p(state.func_177984_a()).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                double d8 = d0 + (double)rand.nextFloat();
                double d4 = d1 + worldIn.func_185900_c((IBlockAccess)pos, (BlockPos)state).field_72337_e;
                double d6 = d2 + (double)rand.nextFloat();
                pos.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
                pos.func_184134_a(d8, d4, d6, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                pos.func_184134_a(d0, d1, d2, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        if (rand.nextInt(10) == 0 && pos.func_180495_p(state.func_177977_b()).func_185896_q() && !(material = pos.func_180495_p(state.func_177979_c(2)).func_185904_a()).func_76230_c() && !material.func_76224_d()) {
            double d3 = d0 + (double)rand.nextFloat();
            double d5 = d1 - 1.05;
            double d7 = d2 + (double)rand.nextFloat();
            if (this.field_149764_J == Material.field_151587_i) {
                pos.func_175688_a(EnumParticleTypes.DRIP_LAVA, d3, d5, d7, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean canCatchFire(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_177230_c().isFlammable(world, pos, face);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        block5: {
            if (this.field_149764_J != Material.field_151572_C || !worldIn.func_82736_K().func_82766_b("doFireTick")) break block5;
            int i = rand.nextInt(3);
            if (i > 0) {
                BlockPos blockpos1 = pos;
                for (int j = 0; j < i; ++j) {
                    Block block = worldIn.func_180495_p(blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, 1, rand.nextInt(3) - 1)).func_177230_c();
                    if (block.func_149688_o(state) == Material.field_151579_a) {
                        if (!this.isSurroundingBlockFlammable(worldIn, blockpos1)) continue;
                        worldIn.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
                        return;
                    }
                    if (!this.field_149764_J.func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos2 = pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1);
                    if (!worldIn.func_175623_d(blockpos2.func_177984_a()) || !this.getCanBlockBurn(worldIn, blockpos2)) continue;
                    worldIn.func_175656_a(blockpos2.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    protected boolean isSurroundingBlockFlammable(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.getCanBlockBurn(worldIn, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(World worldIn, BlockPos pos) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && !worldIn.func_175667_e(pos) ? false : worldIn.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockSC1API.lava_single);
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World worldIn, BlockPos pos) {
        return Item.func_150898_a((Block)BlockSC1API.lava_single);
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getUnlocalizedName();
    }

    public IProperty func_176551_l() {
        return VARIANT;
    }

    public Object getVariant(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        if (itemIn != Item.func_150898_a((Block)BlockSC1API.lava_double)) {
            for (EnumType enumtype : EnumType.values()) {
                list.add(new ItemStack(itemIn, 1, enumtype.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                i |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{SEAMLESS, VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        LAVA(0, "liquid_lava_slab");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] var0 = EnumType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                EnumType var3;
                EnumType.META_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

