/*
 * Decompiled with CFR 0.152.
 */
package slabcraftmod.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slabcraftmod.api.BlockSC1API;

public abstract class BlockWaterSlab
extends BlockSlab {
    public static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)15);

    public BlockWaterSlab() {
        super(Material.field_151572_C);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_180632_j(iblockstate.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.WATER)));
        this.func_149713_g(3);
    }

    public boolean isOpaqueCube() {
        return this.func_176552_j();
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (state.func_185914_p()) {
            return false;
        }
        BlockSlab.EnumBlockHalf side = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        Material material;
        double d0 = state.func_177958_n();
        double d1 = state.func_177956_o();
        double d2 = state.func_177952_p();
        if (this.field_149764_J == Material.field_151586_h) {
            int i = (Integer)worldIn.func_177229_b((IProperty)LEVEL);
            if (i > 0 && i < 8) {
                if (rand.nextInt(64) == 0) {
                    pos.func_184134_a(d0 + 0.5, d1 + 0.5, d2 + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() + 0.5f, false);
                }
            } else if (rand.nextInt(10) == 0) {
                pos.func_175688_a(EnumParticleTypes.SUSPENDED, d0 + (double)rand.nextFloat(), d1 + (double)rand.nextFloat(), d2 + (double)rand.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (rand.nextInt(10) == 0 && pos.func_180495_p(state.func_177977_b()).func_185896_q() && !(material = pos.func_180495_p(state.func_177979_c(2)).func_185904_a()).func_76230_c() && !material.func_76224_d()) {
            double d3 = d0 + (double)rand.nextFloat();
            double d5 = d1 - 1.05;
            double d7 = d2 + (double)rand.nextFloat();
            if (this.field_149764_J == Material.field_151586_h) {
                pos.func_175688_a(EnumParticleTypes.DRIP_WATER, d3, d5, d7, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockSC1API.water_single);
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World worldIn, BlockPos pos) {
        return Item.func_150898_a((Block)BlockSC1API.water_single);
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getUnlocalizedName();
    }

    public IProperty func_176551_l() {
        return VARIANT;
    }

    public Object getVariant(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        if (itemIn != Item.func_150898_a((Block)BlockSC1API.water_double)) {
            for (EnumType enumtype : EnumType.values()) {
                list.add(new ItemStack(itemIn, 1, enumtype.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                i |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{SEAMLESS, VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        WATER(0, "water_slab");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] var0 = EnumType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                EnumType var3;
                EnumType.META_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

