/*
 * Decompiled with CFR 0.152.
 */
package cubex2.ttfr;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import cubex2.ttfr.Config;
import cubex2.ttfr.IBFFontRenderer;
import cubex2.ttfr.StringCache;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class FontRendererCallback {
    public static boolean betterFontsEnabled = true;

    public static void constructor(IBFFontRenderer font, ResourceLocation location) {
        if (((FontRenderer)font).getClass() != FontRenderer.class) {
            return;
        }
        if (location.func_110623_a().equalsIgnoreCase("textures/font/ascii.png") && font.getStringCache() == null) {
            int[] colorCode = (int[])ObfuscationReflectionHelper.getPrivateValue(FontRenderer.class, (Object)((FontRenderer)font), (String[])new String[]{"colorCode", "field_78285_g", "f"});
            font.setStringCache(new StringCache(colorCode));
            Config.applyFont(font);
        }
    }

    public static String bidiReorder(IBFFontRenderer font, String text) {
        if (betterFontsEnabled && font.getStringCache() != null) {
            return text;
        }
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(text), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException var3) {
            return text;
        }
    }
}

