/*
 * Decompiled with CFR 0.152.
 */
package com.gellegbs.lanterns.blocks;

import com.gellegbs.lanterns.Lanterns;
import com.gellegbs.lanterns.blocks.BlockType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockMobLantern
extends BlockDirectional {
    private BlockType type;
    private CreativeTabs displayOnCreativeTab;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon faceIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon blockIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeFaceIcon;

    public BlockMobLantern(BlockType type) {
        super(Material.field_151572_C);
        this.type = type;
        this.func_149647_a(Lanterns.tabMobLanterns);
        this.func_149715_a(1.0f);
        this.func_149663_c(this.type.unlocalizedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.topIcon = register.func_94245_a("lanterns:" + this.type.textureTop);
        this.faceIcon = register.func_94245_a("lanterns:" + this.type.textureFront);
        this.blockIcon = register.func_94245_a("lanterns:" + this.type.textureSide);
        this.activeFaceIcon = register.func_94245_a("lanterns:" + this.type.textureSideActive);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.topIcon;
        }
        if ((metadata & 7) == side) {
            boolean isActive = (metadata & 8) > 0;
            return isActive ? this.activeFaceIcon : this.faceIcon;
        }
        return this.blockIcon;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        int whichDirectionFacing;
        int blockSideWithFace = whichDirectionFacing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        if (whichDirectionFacing == 0) {
            blockSideWithFace = 3;
        } else if (whichDirectionFacing == 1) {
            blockSideWithFace = 4;
        } else if (whichDirectionFacing == 3) {
            blockSideWithFace = 5;
        }
        world.func_72921_c(x, y, z, blockSideWithFace, 2);
        this.updateBlock(world, x, y, z, blockSideWithFace);
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        if (!world.field_72995_K) {
            this.updateBlock(world, x, y, z, world.func_72805_g(x, y, z));
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.updateBlock(world, x, y, z, world.func_72805_g(x, y, z));
        }
    }

    public void updateBlock(World world, int x, int y, int z, int currentMeta) {
        if (!world.field_72995_K) {
            boolean isActive = (currentMeta & 8) > 0;
            boolean redstoneSignal = world.func_72864_z(x, y, z);
            if (redstoneSignal) {
                if (!isActive) {
                    if (this.type.sound != null) {
                        world.func_72908_a((double)x, (double)y, (double)z, this.type.sound, 1.0f, 1.0f);
                    }
                    currentMeta = (currentMeta & 7) + 8;
                    world.func_72921_c(x, y, z, currentMeta, 3);
                }
            } else if (isActive) {
                world.func_72921_c(x, y, z, currentMeta & 7, 3);
            }
        }
    }
}

