/*
 * Decompiled with CFR 0.152.
 */
package com.gellegbs.lanterns.blocks;

import com.gellegbs.lanterns.Lanterns;
import com.gellegbs.lanterns.blocks.BlockType;
import com.gellegbs.lanterns.tileentities.TESpawner;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockSpawner
extends BlockContainer {
    private BlockType type;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon faceIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon blockIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeFaceIcon;

    public BlockSpawner(BlockType type) {
        super(Material.field_151576_e);
        this.type = type;
        this.func_149647_a(Lanterns.tabMobLanterns);
        this.func_149663_c(this.type.unlocalizedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.topIcon = register.func_94245_a("lanterns:" + this.type.textureTop);
        this.faceIcon = register.func_94245_a("lanterns:" + this.type.textureFront);
        this.blockIcon = register.func_94245_a("lanterns:" + this.type.textureSide);
        this.activeFaceIcon = register.func_94245_a("lanterns:" + this.type.textureSideActive);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.topIcon;
        }
        if ((metadata & 7) == side) {
            boolean isActive = (metadata & 8) > 0;
            return isActive ? this.activeFaceIcon : this.faceIcon;
        }
        return this.blockIcon;
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        if (!world.field_72995_K) {
            this.updateBlock(world, x, y, z, world.func_72805_g(x, y, z));
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.updateBlock(world, x, y, z, world.func_72805_g(x, y, z));
        }
    }

    public void updateBlock(World world, int x, int y, int z, int currentMeta) {
        if (!world.field_72995_K) {
            boolean isActive = (currentMeta & 8) > 0;
            boolean redstoneSignal = world.func_72864_z(x, y, z);
            if (redstoneSignal) {
                if (!isActive) {
                    Entity entity;
                    TESpawner spawner;
                    if (this.type.spawnerid != 0 && (spawner = (TESpawner)world.func_147438_o(x, y, z)).isActive() && (entity = EntityList.func_75616_a((int)this.type.spawnerid, (World)world)) != null && entity instanceof EntityLivingBase) {
                        EntityLiving entityliving = (EntityLiving)entity;
                        entity.func_70012_b((double)x, (double)(y + 1), (double)z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                        entityliving.field_70759_as = entityliving.field_70177_z;
                        entityliving.field_70761_aq = entityliving.field_70177_z;
                        entityliving.func_110161_a((IEntityLivingData)null);
                        world.func_72838_d(entity);
                        entityliving.func_70642_aH();
                        if (this.type == BlockType.WITHERSKELESPAWN && entityliving instanceof EntitySkeleton) {
                            EntitySkeleton skeleton = (EntitySkeleton)entityliving;
                            skeleton.func_82201_a(1);
                            skeleton.func_70062_b(0, new ItemStack(Items.field_151052_q));
                            skeleton.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                        }
                        spawner.decreaseUsage();
                    }
                    currentMeta = (currentMeta & 7) + 8;
                    world.func_72921_c(x, y, z, currentMeta, 2);
                }
            } else if (isActive) {
                world.func_72921_c(x, y, z, currentMeta & 7, 2);
            }
        }
    }

    public TileEntity func_149915_a(World world, int n) {
        return new TESpawner();
    }
}

