/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.hopperducts;

import com.google.common.base.Predicate;
import net.fybertech.hopperducts.HopperDuctsMod;
import net.fybertech.hopperducts.TileEntityGratedHopper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGratedHopper
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate(){
        private static final String __OBFID = "CL_00002106";

        public boolean apply(EnumFacing facing) {
            return facing != EnumFacing.UP;
        }

        public boolean apply(Object p_apply_1_) {
            return this.apply((EnumFacing)p_apply_1_);
        }
    });
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");

    public BlockGratedHopper() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)));
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149672_a(SoundType.field_185852_e).func_149711_c(3.0f).func_149752_b(8.0f).func_149663_c("gratedhopper");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing1 = facing.func_176734_d();
        if (enumfacing1 == EnumFacing.UP) {
            enumfacing1 = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing1).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGratedHopper();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityGratedHopper) {
            ((TileEntityGratedHopper)tileentity).setCustomName(stack.func_82833_r());
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateState(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityGratedHopper) {
            playerIn.openGui((Object)HopperDuctsMod.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag;
        boolean bl = flag = !worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityGratedHopper) {
            for (int i = 0; i < 10; ++i) {
                ItemStack itemstack = ((TileEntityGratedHopper)tileentity).func_70301_a(i);
                if (itemstack == null) continue;
                this.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), itemstack);
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private void spawnItemStack(World worldIn, double posX, double posY, double posZ, ItemStack stackIn) {
        float f = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (stackIn.field_77994_a > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > stackIn.field_77994_a) {
                i = stackIn.field_77994_a;
            }
            stackIn.field_77994_a -= i;
            EntityItem entityitem = new EntityItem(worldIn, posX + (double)f, posY + (double)f1, posZ + (double)f2, new ItemStack(stackIn.func_77973_b(), i, stackIn.func_77960_j()));
            if (stackIn.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)stackIn.func_77978_p().func_74737_b());
            }
            float f3 = 0.05f;
            entityitem.field_70159_w = RANDOM.nextGaussian() * (double)f3;
            entityitem.field_70181_x = RANDOM.nextGaussian() * (double)f3 + (double)0.2f;
            entityitem.field_70179_y = RANDOM.nextGaussian() * (double)f3;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public static EnumFacing getFacing(int meta) {
        return EnumFacing.func_82600_a((int)(meta & 7));
    }

    public static boolean isEnabled(int meta) {
        return (meta & 8) != 8;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockGratedHopper.getFacing(meta)).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(BlockGratedHopper.isEnabled(meta)));
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (!((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ENABLED});
    }
}

