/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn;

import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import two.newdawn.NewDawn;
import two.newdawn.util.Utils;

public class Config {
    protected static final String CATEGORY_ALLOWED_RECIPES = "Allowed Recipes";
    protected static final String CATEGORY_VARIOUS_SETTINGS = "Settings";
    protected static final String CATEGORY_THAUMCRAFT_SETTINGS = "Thaumcraft Compatibility";
    protected static final String PREFIX_TILE = "tile.";
    protected Configuration configuration;

    protected Config() {
    }

    protected void initialize(File configFile) {
        this.configuration = new Configuration(configFile);
    }

    protected void load() {
        this.configuration.load();
    }

    protected void save() {
        this.configuration.save();
    }

    public boolean isCraftingEnabled(String key) {
        return this.isCraftingEnabled(key, true);
    }

    public boolean isCraftingEnabled(String key, boolean defaultValue) {
        Property property = this.configuration.get(CATEGORY_ALLOWED_RECIPES, key, defaultValue);
        return property.getBoolean(defaultValue);
    }

    public int getMiscInteger(String key, int defaultValue) {
        return this.getMiscInteger(key, defaultValue, null);
    }

    public int getMiscInteger(String key, int defaultValue, String comment) {
        Property property = this.configuration.get(CATEGORY_VARIOUS_SETTINGS, key, defaultValue, comment);
        return property.getInt(defaultValue);
    }

    public double getMiscDouble(String key, double defaultValue) {
        return this.getMiscDouble(key, defaultValue, null);
    }

    public double getMiscDouble(String key, double defaultValue, String comment) {
        Property property = this.configuration.get(CATEGORY_VARIOUS_SETTINGS, key, defaultValue, comment);
        return property.getDouble(defaultValue);
    }

    public boolean getMiscBoolean(String key, boolean defaultValue) {
        return this.getMiscBoolean(key, defaultValue, null);
    }

    public boolean getMiscBoolean(String key, boolean defaultValue, String comment) {
        Property property = this.configuration.get(CATEGORY_VARIOUS_SETTINGS, key, defaultValue, comment);
        return property.getBoolean(defaultValue);
    }

    public List<String> getMiscStrings(String key, List<String> defaultValue) {
        return this.getMiscStrings(key, defaultValue, null);
    }

    public List<String> getMiscStrings(String key, List<String> defaultValue, String comment) {
        Property property = this.configuration.get(CATEGORY_VARIOUS_SETTINGS, key, defaultValue.toArray(new String[defaultValue.size()]), comment);
        return Arrays.asList(property.getStringList());
    }

    public List<Block> getMiscBlocks(String key, List<Block> defaultValue) {
        return this.getMiscBlocks(key, defaultValue, null);
    }

    public List<Block> getMiscBlocks(String key, List<Block> defaultValue, String comment) {
        String[] defaultValueStrings = this.blockListToBlockNames(defaultValue);
        Property property = this.configuration.get(CATEGORY_VARIOUS_SETTINGS, key, defaultValueStrings, comment);
        return this.blockNamesToBlockList(property.getStringList());
    }

    public double getThaumcraftDouble(String key, double defaultValue) {
        return this.getThaumcraftDouble(key, defaultValue, null);
    }

    public double getThaumcraftDouble(String key, double defaultValue, String comment) {
        Property property = this.configuration.get(CATEGORY_THAUMCRAFT_SETTINGS, key, defaultValue, comment);
        return property.getDouble(defaultValue);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected String[] blockListToBlockNames(List<Block> blockList) {
        if (blockList == null || blockList.isEmpty()) {
            return new String[0];
        }
        Object[] result = new String[blockList.size()];
        int index = 0;
        for (Block block : blockList) {
            String blockname = GameData.getBlockRegistry().func_148750_c((Object)block);
            if (blockname != null) {
                result[index] = blockname;
                ++index;
                continue;
            }
            NewDawn.log.warn("Ignoring invalid block configuration entry: %s", new Object[]{Utils.blockToString(block)});
        }
        Arrays.sort(result);
        return result;
    }

    protected List<Block> blockNamesToBlockList(String[] blockNames) {
        if (blockNames == null || blockNames.length == 0) {
            return new ArrayList<Block>();
        }
        ArrayList<Block> result = new ArrayList<Block>(blockNames.length);
        Arrays.sort(blockNames);
        for (String blockName : blockNames) {
            Block block = Block.func_149684_b((String)blockName);
            if (block != null) {
                result.add(block);
                continue;
            }
            NewDawn.log.warn("Ignoring invalid block configuration entry: %s", new Object[]{String.valueOf(blockName)});
        }
        return result;
    }
}

