/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import two.newdawn.API.NewDawnRegistry;
import two.newdawn.Config;
import two.newdawn.NewDawnWorldType;
import two.newdawn.commands.CommandGenerateWorld;
import two.newdawn.worldgen.thaumcraft.ThaumcraftBiomeProvider;
import two.newdawn.worldgen.vanilla.VanillaBiomeProvider;

@Mod(modid="newdawn", name="New Dawn", version="1710.1.0")
public class NewDawn {
    public static final String MOD_NAME = "New Dawn";
    public static final String MOD_ID = "newdawn";
    public static final String MOD_VERSION = "1710.1.0";
    public static final Logger log = LogManager.getLogger((String)NewDawn.class.getSimpleName(), (MessageFactory)new StringFormatterMessageFactory());
    @Mod.Instance(value="NewDawn")
    public static NewDawn instance;
    public static final Config config;
    protected NewDawnWorldType worldType;
    protected boolean thaumcraftSupportEnabled;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config.initialize(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        config.load();
        this.worldType = new NewDawnWorldType();
        this.thaumcraftSupportEnabled = config.getMiscBoolean("Enable internal Thaumcraft support", true);
        if (this.thaumcraftSupportEnabled) {
            ThaumcraftBiomeProvider.prepareThaumcraftSupport(config);
        }
        config.save();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NewDawnRegistry.registerProvider(new VanillaBiomeProvider());
        if (this.thaumcraftSupportEnabled && Loader.isModLoaded((String)"Thaumcraft")) {
            NewDawnRegistry.registerProvider(new ThaumcraftBiomeProvider());
            log.info("Internal Thaumcraft support enabled.");
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ICommandManager commandManager = server.func_71187_D();
        if (commandManager instanceof ServerCommandManager) {
            ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
            serverCommandManager.func_71560_a((ICommand)new CommandGenerateWorld());
        } else {
            FMLLog.warning((String)"Unable to get server command manager. No slash-commands will be available.", (Object[])new Object[0]);
        }
    }

    static {
        config = new Config();
    }
}

