/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn.worldgen.vanilla;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.noise.SimplexNoise;

public class VanillaBeachSelector
extends NewDawnBiomeSelector {
    protected final NewDawnBiome[][] selection = new NewDawnBiome[ChunkInformation.Temperature.values().length][ChunkInformation.Humidity.values().length];

    public VanillaBeachSelector(SimplexNoise worldNoise, int priority) {
        super(worldNoise, priority);
        this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.sparse.ordinal()] = new NewDawnBiome(BiomeGenBase.field_150577_O, Blocks.field_150348_b, Blocks.field_150348_b);
        this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.sparse.ordinal()] = new NewDawnBiome(BiomeGenBase.field_76787_r, Blocks.field_150351_n, Blocks.field_150348_b);
        this.selection[ChunkInformation.Temperature.hot.ordinal()][ChunkInformation.Humidity.sparse.ordinal()] = new NewDawnBiome(BiomeGenBase.field_76787_r, (Block)Blocks.field_150354_m, (Block)Blocks.field_150354_m);
        this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.medium.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_150577_O);
        this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.medium.ordinal()] = new NewDawnBiome(BiomeGenBase.field_76787_r, (Block)Blocks.field_150349_c, Blocks.field_150346_d);
        this.selection[ChunkInformation.Temperature.hot.ordinal()][ChunkInformation.Humidity.medium.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_150588_X);
        this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.woodland.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_150584_S);
        this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.woodland.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_76767_f);
        this.selection[ChunkInformation.Temperature.hot.ordinal()][ChunkInformation.Humidity.woodland.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_76782_w);
        this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.wet.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_150584_S);
        this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.wet.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_76780_h);
        this.selection[ChunkInformation.Temperature.hot.ordinal()][ChunkInformation.Humidity.wet.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_76780_h);
    }

    @Override
    public NewDawnBiome selectBiome(int blockX, int blockZ, ChunkInformation chunkInfo) {
        if (chunkInfo.isGroundLevelOrShallowWater(blockX, blockZ)) {
            int temperature = chunkInfo.getTemperatureType(blockX, blockZ).ordinal();
            int humidity = chunkInfo.getHumidityType(blockX, blockZ).ordinal();
            return this.selection[temperature][humidity];
        }
        return null;
    }
}

