/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn.worldgen.vanilla;

import net.minecraft.world.biome.BiomeGenBase;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.noise.SimplexNoise;

public class VanillaOceanSelector
extends NewDawnBiomeSelector {
    public static final NewDawnBiome biomeColdOcean = NewDawnBiome.copyVanilla(BiomeGenBase.field_76776_l);
    public static final NewDawnBiome biomeOcean = NewDawnBiome.copyVanilla(BiomeGenBase.field_76771_b);
    public static final NewDawnBiome biomeDeepOcean = NewDawnBiome.copyVanilla(BiomeGenBase.field_150575_M);

    public VanillaOceanSelector(SimplexNoise worldNoise, int priority) {
        super(worldNoise, priority);
    }

    @Override
    public NewDawnBiome selectBiome(int blockX, int blockZ, ChunkInformation chunkInfo) {
        if (chunkInfo.isBelowGroundLevel(blockX, blockZ)) {
            if (chunkInfo.isTemperatureFreezing(blockX, blockZ)) {
                return biomeColdOcean;
            }
            if (chunkInfo.isDeepOcean(blockX, blockZ)) {
                return biomeDeepOcean;
            }
            return biomeOcean;
        }
        return null;
    }
}

