/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn.API;

import java.util.HashMap;
import two.newdawn.API.WorldBaseValues;

public class ChunkInformation {
    public static final int WORLD_HEIGHT = 256;
    public static final double BLOCK_SCALE = 2.0;
    public static final int CHUNK_SIZE_X = 16;
    public static final int CHUNK_SIZE_Z = 16;
    public static final int CHUNK_SIZE_XZ = 256;
    protected static final int LENGTH_MASK = 15;
    public final int chunkX;
    public final int chunkZ;
    public final WorldBaseValues baseValues;
    public final int[] height;
    public final int[] regionHeight;
    public final boolean[] isMountain;
    public final float[] temperature;
    public final float[] humidity;
    protected int lowestHeight;
    protected int averageHeight;
    protected int highestHeight;
    protected float lowestTemperature;
    protected float averageTemperature;
    protected float highestTemperature;
    protected float lowestHumidity;
    protected float averageHumidity;
    protected float highestHumidity;
    public final HashMap<String, Object> additionalInformation = new HashMap();

    public static int blockToChunk(int blockX, int blockZ) {
        return (blockX & 0xF) + (blockZ & 0xF) * 16;
    }

    public ChunkInformation(int chunkX, int chunkZ, WorldBaseValues basicInfo, int[] height, int[] regionHeight, boolean[] isMountain, float[] temperature, float[] humidity) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.height = height;
        this.regionHeight = regionHeight;
        this.isMountain = isMountain;
        this.baseValues = basicInfo;
        this.temperature = temperature;
        this.humidity = humidity;
    }

    public void updateMinMaxInformation() {
        int lowHeight = Integer.MAX_VALUE;
        int highHight = Integer.MIN_VALUE;
        int avgHeight = 0;
        for (int h : this.height) {
            avgHeight += h;
            lowHeight = Math.min(h, lowHeight);
            highHight = Math.max(h, highHight);
        }
        this.lowestHeight = lowHeight;
        this.averageHeight = Math.round((float)avgHeight / (float)this.height.length);
        this.highestHeight = highHight;
        float lowTemperature = this.temperature[0];
        float avgTemperature = 0.0f;
        float highTemperature = this.temperature[0];
        for (float t : this.temperature) {
            avgTemperature += t;
            lowTemperature = Math.min(t, lowTemperature);
            highTemperature = Math.max(t, highTemperature);
        }
        this.lowestTemperature = lowTemperature;
        this.averageTemperature = avgTemperature / (float)this.temperature.length;
        this.highestTemperature = highTemperature;
        float lowHumidity = this.humidity[0];
        float avgHumidity = 0.0f;
        float highHumidity = this.humidity[0];
        for (float h : this.humidity) {
            avgHumidity += h;
            lowHumidity = Math.min(h, lowHumidity);
            highHumidity = Math.max(h, highHumidity);
        }
        this.lowestHumidity = lowHumidity;
        this.averageHumidity = avgHumidity / (float)this.humidity.length;
        this.highestHumidity = highHumidity;
    }

    public int getHeight(int blockX, int blockZ) {
        return this.height[ChunkInformation.blockToChunk(blockX, blockZ)];
    }

    public int getRegionHeight(int blockX, int blockZ) {
        return this.regionHeight[ChunkInformation.blockToChunk(blockX, blockZ)];
    }

    public int getElevation(int blockX, int blockZ) {
        int heightRegion = this.getRegionHeight(blockX, blockZ);
        if (heightRegion >= 0) {
            return this.getHeight(blockX, blockZ) - heightRegion;
        }
        return 0;
    }

    public boolean isMountain(int blockX, int blockZ) {
        return this.isMountain[ChunkInformation.blockToChunk(blockX, blockZ)];
    }

    public float getTemperature(int blockX, int blockZ) {
        return this.temperature[ChunkInformation.blockToChunk(blockX, blockZ)];
    }

    public Temperature getTemperatureType(int blockX, int blockZ) {
        float temp = this.temperature[ChunkInformation.blockToChunk(blockX, blockZ)];
        if (temp <= this.baseValues.temperatureFreezing) {
            return Temperature.cold;
        }
        if (temp >= this.baseValues.temperatureHot) {
            return Temperature.hot;
        }
        return Temperature.medium;
    }

    public float getHumidity(int blockX, int blockZ) {
        return this.humidity[ChunkInformation.blockToChunk(blockX, blockZ)];
    }

    public Humidity getHumidityType(int blockX, int blockZ) {
        float humid = this.humidity[ChunkInformation.blockToChunk(blockX, blockZ)];
        if (humid <= this.baseValues.humiditySparse) {
            return Humidity.sparse;
        }
        if (humid >= this.baseValues.humidityWet) {
            return Humidity.wet;
        }
        if (humid >= this.baseValues.minHumidityWoodland) {
            return Humidity.woodland;
        }
        return Humidity.medium;
    }

    public boolean isTemperatureHot(int blockX, int blockZ) {
        return this.getTemperature(blockX, blockZ) >= this.baseValues.temperatureHot;
    }

    public boolean isTemperatureHot(int blockX, int blockZ, float modifier) {
        return this.getTemperature(blockX, blockZ) + modifier >= this.baseValues.temperatureHot;
    }

    public boolean isTemperatureFreezing(int blockX, int blockZ) {
        return this.getTemperature(blockX, blockZ) <= this.baseValues.temperatureFreezing;
    }

    public boolean isTemperatureFreezing(int blockX, int blockZ, float modifier) {
        return this.getTemperature(blockX, blockZ) + modifier <= this.baseValues.temperatureFreezing;
    }

    public boolean isTemperatureMedium(int blockX, int blockZ) {
        float blockTemperature = this.getTemperature(blockX, blockZ);
        return blockTemperature > this.baseValues.temperatureFreezing && blockTemperature < this.baseValues.temperatureHot;
    }

    public boolean isTemperatureMedium(int blockX, int blockZ, float modifier) {
        float blockTemperature = this.getTemperature(blockX, blockZ) + modifier;
        return blockTemperature > this.baseValues.temperatureFreezing && blockTemperature < this.baseValues.temperatureHot;
    }

    public boolean isHumidityWet(int blockX, int blockZ) {
        return this.getHumidity(blockX, blockZ) >= this.baseValues.humidityWet;
    }

    public boolean isHumidityWet(int blockX, int blockZ, float modifier) {
        return this.getHumidity(blockX, blockZ) + modifier >= this.baseValues.humidityWet;
    }

    public boolean isHumiditySparse(int blockX, int blockZ) {
        return this.getHumidity(blockX, blockZ) <= this.baseValues.humiditySparse;
    }

    public boolean isHumiditySparse(int blockX, int blockZ, float modifier) {
        return this.getHumidity(blockX, blockZ) + modifier <= this.baseValues.humiditySparse;
    }

    public boolean isHumidityMedium(int blockX, int blockZ) {
        float blockHumidity = this.getHumidity(blockX, blockZ);
        return blockHumidity > this.baseValues.humiditySparse && blockHumidity < this.baseValues.humidityWet;
    }

    public boolean isHumidityMedium(int blockX, int blockZ, float modifier) {
        float blockHumidity = this.getHumidity(blockX, blockZ) + modifier;
        return blockHumidity > this.baseValues.humiditySparse && blockHumidity < this.baseValues.humidityWet;
    }

    public boolean isWoodland(int blockX, int blockZ) {
        return this.getHumidity(blockX, blockZ) >= this.baseValues.minHumidityWoodland;
    }

    public boolean isWoodland(int blockX, int blockZ, float modifier) {
        return this.getHumidity(blockX, blockZ) + modifier >= this.baseValues.minHumidityWoodland;
    }

    public boolean isGroundLevel(int blockX, int blockZ) {
        return this.getHeight(blockX, blockZ) == this.baseValues.groundLevel;
    }

    public boolean isAboveSeaLevel(int blockX, int blockZ) {
        return this.getHeight(blockX, blockZ) >= this.baseValues.groundLevel;
    }

    public boolean isBelowGroundLevel(int blockX, int blockZ) {
        return this.getHeight(blockX, blockZ) < this.baseValues.groundLevel;
    }

    public boolean isDeepWater(int blockX, int blockZ) {
        return this.getHeight(blockX, blockZ) + 1 < this.baseValues.groundLevel;
    }

    public boolean isDeepOcean(int blockX, int blockZ) {
        return this.getHeight(blockX, blockZ) + 4 < this.baseValues.groundLevel;
    }

    public boolean isShallowWater(int blockX, int blockZ) {
        return this.getHeight(blockX, blockZ) + 1 == this.baseValues.groundLevel;
    }

    public boolean isGroundLevelOrShallowWater(int blockX, int blockZ) {
        int blockHeight = this.getHeight(blockX, blockZ);
        return blockHeight == this.baseValues.groundLevel || blockHeight + 1 == this.baseValues.groundLevel;
    }

    public float getAverageHumidity() {
        return this.averageHumidity;
    }

    public float getAverageTemperature() {
        return this.averageTemperature;
    }

    public int getAverageHeight() {
        return this.averageHeight;
    }

    public int getLowestHeight() {
        return this.lowestHeight;
    }

    public int getHighestHeight() {
        return this.highestHeight;
    }

    public float getLowestTemperature() {
        return this.lowestTemperature;
    }

    public float getHighestTemperature() {
        return this.highestTemperature;
    }

    public float getLowestHumidity() {
        return this.lowestHumidity;
    }

    public float getHighestHumidity() {
        return this.highestHumidity;
    }

    public int getHeightDifference() {
        return this.highestHeight - this.lowestHeight;
    }

    public float getTemperatureDifference() {
        return this.highestTemperature - this.lowestTemperature;
    }

    public float getHumidityDifference() {
        return this.highestHumidity - this.lowestHumidity;
    }

    public static enum Humidity {
        sparse,
        medium,
        woodland,
        wet;

    }

    public static enum Temperature {
        cold,
        medium,
        hot;

    }
}

