/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn.API;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.noise.SimplexNoise;

public class NewDawnBiome {
    public final BiomeGenBase vanillaBiome;
    public final Block topBlock;
    public final Block fillerBlock;
    public final Block groundBlock;

    public static NewDawnBiome copyVanilla(BiomeGenBase vanillaBiome) {
        return new NewDawnBiome(vanillaBiome, vanillaBiome.field_76752_A, vanillaBiome.field_76753_B, Blocks.field_150348_b);
    }

    public NewDawnBiome(BiomeGenBase vanillaBiome, Block topBlock, Block fillerBlock) {
        this(vanillaBiome, topBlock, fillerBlock, Blocks.field_150348_b);
    }

    public NewDawnBiome(BiomeGenBase vanillaBiome, Block topBlock, Block fillerBlock, Block groundBlock) {
        this.vanillaBiome = vanillaBiome;
        this.topBlock = topBlock;
        this.fillerBlock = fillerBlock;
        this.groundBlock = groundBlock;
    }

    public void fillLocation(SimplexNoise worldNoise, Block[] chunkData, int dataPos, int height, int fillerHeight, int blockX, int blockZ, ChunkInformation chunkInfo) {
        int bedrockHeight = this.fillBedrock(worldNoise, chunkData, dataPos, height, fillerHeight, blockX, blockZ, chunkInfo);
        this.fillGround(worldNoise, chunkData, dataPos, height, bedrockHeight, fillerHeight, blockX, blockZ, chunkInfo);
        if (chunkInfo.isBelowGroundLevel(blockX, blockZ)) {
            this.fillWater(worldNoise, chunkData, dataPos, height, fillerHeight, blockX, blockZ, chunkInfo);
        }
    }

    protected int fillBedrock(SimplexNoise worldNoise, Block[] chunkData, int dataPos, int height, int fillerHeight, int blockX, int blockZ, ChunkInformation chunkInfo) {
        int bedrockHeight = Math.min(height, 5);
        chunkData[dataPos] = Blocks.field_150357_h;
        for (int i = 1; i < bedrockHeight; ++i) {
            chunkData[dataPos + i] = worldNoise.noise(blockX, i, blockZ) <= 0.0 ? Blocks.field_150357_h : this.groundBlock;
        }
        return bedrockHeight;
    }

    protected void fillGround(SimplexNoise worldNoise, Block[] chunkData, int dataPos, int height, int bedrockHeight, int fillerHeight, int blockX, int blockZ, ChunkInformation chunkInfo) {
        if (fillerHeight > bedrockHeight) {
            Arrays.fill(chunkData, dataPos + bedrockHeight, dataPos + fillerHeight, this.groundBlock);
            Arrays.fill(chunkData, dataPos + fillerHeight, dataPos + height - 1, this.fillerBlock);
            if (this.fillerBlock == Blocks.field_150354_m) {
                Arrays.fill(chunkData, dataPos + fillerHeight, dataPos + (height - 1 + fillerHeight) / 2, Blocks.field_150322_A);
            }
        } else {
            Arrays.fill(chunkData, dataPos + bedrockHeight, dataPos + height - 1, this.groundBlock);
        }
        chunkData[dataPos + height - 1] = this.topBlock;
    }

    protected void fillWater(SimplexNoise worldNoise, Block[] chunkData, int dataPos, int height, int fillerHeight, int blockX, int blockZ, ChunkInformation chunkInfo) {
        if (this.topBlock == Blocks.field_150349_c) {
            chunkData[dataPos + height - 1] = Blocks.field_150346_d;
        }
        Arrays.fill(chunkData, dataPos + height, dataPos + chunkInfo.baseValues.groundLevel, Blocks.field_150355_j);
    }
}

